/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.engines;

import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.engines.BlockEngineBase;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.render.RenderResizableCuboid;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.core.lib.utils.Utils;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class RenderEngine
extends TileEntitySpecialRenderer<TileEngineBase> {
    private static final float[] angleMap = new float[6];
    private TextureAtlasSprite spriteChamber;
    private final Map<EnumEngineType, TextureAtlasSprite> spriteBoxSide = Maps.newEnumMap(EnumEngineType.class);
    private final Map<EnumEngineType, TextureAtlasSprite> spriteBoxTop = Maps.newEnumMap(EnumEngineType.class);

    public RenderEngine() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void textureStitchPost(TextureStitchEvent.Post post) {
        this.spriteChamber = post.map.func_110572_b("buildcraftcore:blocks/engine/inv/chamber_base");
        for (EnumEngineType type : EnumEngineType.values()) {
            this.spriteBoxSide.put(type, post.map.func_110572_b(type.resourceLocation + "side"));
            this.spriteBoxTop.put(type, post.map.func_110572_b(type.resourceLocation + "back"));
        }
    }

    public void renderTileEntityAt(TileEngineBase engine, double x, double y, double z, float f, int wtfIsThis) {
        BlockPos pos;
        World world;
        IBlockState engineState;
        if (engine != null && (engineState = (world = engine.func_145831_w()).func_180495_p(pos = engine.func_174877_v())).func_177230_c() instanceof BlockEngineBase && ((Boolean)(engineState = engineState.func_177230_c().func_176221_a(engineState, (IBlockAccess)world, pos)).func_177229_b(BuildCraftProperties.MOVING)).booleanValue()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            this.fireRenderer(engine.type, engine.orientation, engine.progress, pos);
            GL11.glPopMatrix();
        }
    }

    private void fireRenderer(EnumEngineType type, EnumFacing face, float progress, BlockPos pos) {
        if ((double)progress > 0.5) {
            progress = 1.0f - progress;
        }
        progress *= 2.0f;
        final Vec3 coord = Utils.convert((Vec3i)pos);
        RenderResizableCuboid.IBlockLocation locationFormula = new RenderResizableCuboid.IBlockLocation(){

            @Override
            public Vec3 transformToWorld(Vec3 vec) {
                return coord;
            }
        };
        RenderResizableCuboid.RotatedFacingLocation faceFormula = new RenderResizableCuboid.RotatedFacingLocation(EnumFacing.UP, face);
        GL11.glPushMatrix();
        RenderUtils.translate(Utils.VEC_HALF);
        if (face == EnumFacing.DOWN) {
            GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        } else if (face != EnumFacing.UP) {
            GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            int angle = 0;
            for (EnumFacing tempFace = face; tempFace != EnumFacing.SOUTH; tempFace = tempFace.func_176735_f()) {
                angle += 90;
            }
            GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)(-angle), (double)0.0, (double)1.0, (double)0.0);
        }
        RenderUtils.translate(Utils.vec3(-0.5));
        EntityResizableCuboid chamberCuboid = new EntityResizableCuboid(this.func_178459_a());
        chamberCuboid.texture = this.spriteChamber;
        chamberCuboid.setTextureOffset(new Vec3(3.0, 0.0, 3.0));
        Vec3 chamberSize = Utils.divide(new Vec3(10.0, (double)(progress * 8.0f), 10.0), 16.0);
        chamberCuboid.setSize(chamberSize);
        Vec3 chamberOffset = Utils.divide(new Vec3(3.0, 4.0, 3.0), 16.0);
        RenderUtils.translate(chamberOffset);
        RenderResizableCuboid.INSTANCE.renderCube(chamberCuboid, RenderResizableCuboid.EnumShadeArgument.FACE_LIGHT, locationFormula, faceFormula);
        RenderUtils.translate(Utils.multiply(chamberOffset, -1.0));
        EntityResizableCuboid boxCuboid = new EntityResizableCuboid(this.func_178459_a());
        boxCuboid.texture = this.spriteBoxSide.get((Object)type);
        boxCuboid.makeClient();
        boxCuboid.textures[EnumFacing.UP.ordinal()] = this.spriteBoxTop.get((Object)type);
        boxCuboid.textures[EnumFacing.DOWN.ordinal()] = this.spriteBoxTop.get((Object)type);
        Vec3 boxSize = Utils.divide(new Vec3(16.0, 4.0, 16.0), 16.0);
        boxCuboid.setSize(boxSize);
        Vec3 boxOffset = new Vec3(0.0, 0.25 + (double)(progress / 2.0f), 0.0);
        RenderUtils.translate(boxOffset);
        RenderResizableCuboid.INSTANCE.renderCube(boxCuboid, RenderResizableCuboid.EnumShadeArgument.FACE_LIGHT, locationFormula, faceFormula);
        RenderUtils.translate(Utils.multiply(boxOffset, -1.0));
        GL11.glPopMatrix();
    }

    static {
        RenderEngine.angleMap[EnumFacing.EAST.ordinal()] = -1.5707964f;
        RenderEngine.angleMap[EnumFacing.WEST.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[EnumFacing.UP.ordinal()] = 0.0f;
        RenderEngine.angleMap[EnumFacing.DOWN.ordinal()] = (float)Math.PI;
        RenderEngine.angleMap[EnumFacing.SOUTH.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[EnumFacing.NORTH.ordinal()] = -1.5707964f;
    }
}

