/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui;

import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiBuildCraft;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiAdvancedInterface
extends GuiBuildCraft {
    public ArrayList<AdvancedSlot> slots = new ArrayList();

    public GuiAdvancedInterface(BuildCraftContainer container, IInventory inventory, ResourceLocation texture) {
        super(container, inventory, texture);
    }

    public int getSlotIndexAtLocation(int i, int j) {
        int x = i - this.field_147003_i;
        int y = j - this.field_147009_r;
        for (int position = 0; position < this.slots.size(); ++position) {
            AdvancedSlot s = this.slots.get(position);
            if (s == null || x < s.x || x > s.x + 16 || y < s.y || y > s.y + 16) continue;
            return position;
        }
        return -1;
    }

    public AdvancedSlot getSlotAtLocation(int i, int j) {
        int id = this.getSlotIndexAtLocation(i, j);
        if (id != -1) {
            return this.slots.get(id);
        }
        return null;
    }

    private boolean isMouseOverSlot(AdvancedSlot slot, int mouseX, int mouseY) {
        int realMouseX = mouseX - this.field_147003_i;
        int realMouseY = mouseY - this.field_147009_r;
        return realMouseX >= slot.x - 1 && realMouseX < slot.x + 16 + 1 && realMouseY >= slot.y - 1 && realMouseY < slot.y + 16 + 1;
    }

    protected void drawSlotHighlight(AdvancedSlot slot, int mouseX, int mouseY) {
        if (this.isMouseOverSlot(slot, mouseX, mouseY) && slot.shouldDrawHighlight()) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179141_d();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(this.field_147003_i + slot.x, this.field_147009_r + slot.y, this.field_147003_i + slot.x + 16, this.field_147009_r + slot.y + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
    }

    protected void drawBackgroundSlots(int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)4096);
        GlStateManager.func_179091_B();
        int i1 = 240;
        int k1 = 240;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)i1 / 1.0f), (float)((float)k1 / 1.0f));
        if (this.slots != null) {
            for (AdvancedSlot slot : this.slots) {
                if (slot == null) continue;
                slot.drawSprite(this.field_147003_i, this.field_147009_r);
                this.drawSlotHighlight(slot, mouseX, mouseY);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179101_C();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void drawTooltipForSlotAt(int mouseX, int mouseY) {
        AdvancedSlot slot = this.getSlotAtLocation(mouseX, mouseY);
        if (slot != null) {
            slot.drawTooltip(this, mouseX, mouseY);
        }
    }

    public void drawTooltip(String caption, int mouseX, int mouseY) {
        if (caption.length() > 0) {
            int i2 = mouseX - this.field_147003_i;
            int k2 = mouseY - this.field_147009_r;
            this.func_146279_a(caption, i2, k2);
        }
    }

    public RenderItem getItemRenderer() {
        return this.field_146296_j;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    public void func_146285_a(ItemStack stack, int x, int y) {
        super.func_146285_a(stack, x, y);
    }

    public void drawStack(ItemStack item, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        if (item != null) {
            GlStateManager.func_179145_e();
            float prevZ = this.getItemRenderer().field_77023_b;
            this.getItemRenderer().field_77023_b = 200.0f;
            this.getItemRenderer().func_180450_b(item, x, y);
            this.getItemRenderer().func_180453_a(mc.field_71466_p, item, x, y, null);
            this.getItemRenderer().field_77023_b = prevZ;
            GlStateManager.func_179140_f();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        AdvancedSlot slot = this.getSlotAtLocation(mouseX, mouseY);
        if (slot != null && slot.isDefined()) {
            this.slotClicked(slot, mouseButton);
        }
    }

    public void resetNullSlots(int size) {
        this.slots.clear();
        for (int i = 0; i < size; ++i) {
            this.slots.add(null);
        }
    }

    protected void slotClicked(AdvancedSlot slot, int mouseButton) {
    }
}

