/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui.buttons;

import buildcraft.core.lib.gui.buttons.IButtonClickEventListener;
import buildcraft.core.lib.gui.buttons.IButtonClickEventTrigger;
import buildcraft.core.lib.gui.tooltips.IToolTipProvider;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiImageButton
extends GuiButton
implements IButtonClickEventTrigger,
IToolTipProvider {
    private final int size;
    private final int u;
    private final int v;
    private final int baseU;
    private final int baseV;
    private final ResourceLocation texture;
    private ArrayList<IButtonClickEventListener> listeners = new ArrayList();
    private boolean active = false;
    private ToolTip toolTip;

    public GuiImageButton(int id, int x, int y, int size, ResourceLocation texture, int u, int v) {
        this(id, x, y, size, texture, 0, 0, u, v);
    }

    public GuiImageButton(int id, int x, int y, int size, ResourceLocation texture, int baseU, int baseV, int u, int v) {
        super(id, x, y, size, size, "");
        this.size = size;
        this.u = u;
        this.v = v;
        this.baseU = baseU;
        this.baseV = baseV;
        this.texture = texture;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deActivate() {
        this.active = false;
    }

    public void func_146112_a(Minecraft minecraft, int x, int y) {
        if (!this.field_146125_m) {
            return;
        }
        minecraft.field_71446_o.func_110577_a(this.texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        int buttonState = this.getButtonState(x, y);
        this.func_73729_b(this.field_146128_h, this.field_146129_i, this.baseU + buttonState * this.size, this.baseV, this.size, this.size);
        this.func_73729_b(this.field_146128_h + 1, this.field_146129_i + 1, this.u, this.v, this.size - 2, this.size - 2);
        this.func_146119_b(minecraft, x, y);
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        boolean pressed = super.func_146116_c(par1Minecraft, par2, par3);
        if (pressed) {
            this.active = !this.active;
            this.notifyAllListeners();
        }
        return pressed;
    }

    @Override
    public void registerListener(IButtonClickEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IButtonClickEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyAllListeners() {
        for (IButtonClickEventListener listener : this.listeners) {
            listener.handleButtonClick(this, this.field_146127_k);
        }
    }

    private int getButtonState(int mouseX, int mouseY) {
        if (!this.field_146124_l) {
            return 0;
        }
        if (this.isMouseOverButton(mouseX, mouseY)) {
            if (!this.active) {
                return 2;
            }
            return 4;
        }
        if (!this.active) {
            return 1;
        }
        return 3;
    }

    private boolean isMouseOverButton(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.size && mouseY < this.field_146129_i + this.size;
    }

    @Override
    public ToolTip getToolTip() {
        return this.toolTip;
    }

    public GuiImageButton setToolTip(ToolTip tips) {
        this.toolTip = tips;
        return this;
    }

    @Override
    public boolean isToolTipVisible() {
        return this.field_146125_m;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.isMouseOverButton(mouseX, mouseY);
    }
}

