/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.inventory;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.IStackFilter;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.inventory.Transactor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class TransactorSimple
extends Transactor {
    protected IInventory inventory;

    public TransactorSimple(IInventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public int inject(ItemStack stack, EnumFacing orientation, boolean doAdd) {
        ArrayList<IInvSlot> filledSlots = new ArrayList<IInvSlot>(this.inventory.func_70302_i_());
        ArrayList<IInvSlot> emptySlots = new ArrayList<IInvSlot>(this.inventory.func_70302_i_());
        for (IInvSlot slot : InventoryIterator.getIterable(this.inventory, orientation)) {
            if (!slot.canPutStackInSlot(stack)) continue;
            if (slot.getStackInSlot() == null) {
                emptySlots.add(slot);
                continue;
            }
            filledSlots.add(slot);
        }
        int injected = 0;
        injected = this.tryPut(stack, filledSlots, injected, doAdd);
        if ((injected = this.tryPut(stack, emptySlots, injected, doAdd)) > 0 && doAdd) {
            this.inventory.func_70296_d();
        }
        return injected;
    }

    private int tryPut(ItemStack stack, List<IInvSlot> slots, int injected, boolean doAdd) {
        int realInjected = injected;
        if (realInjected >= stack.field_77994_a) {
            return realInjected;
        }
        for (IInvSlot slot : slots) {
            int used;
            ItemStack stackInSlot = slot.getStackInSlot();
            if (stackInSlot != null && !StackHelper.canStacksMerge(stackInSlot, stack) || (used = this.addToSlot(slot, stack, realInjected, doAdd)) <= 0 || (realInjected += used) < stack.field_77994_a) continue;
            return realInjected;
        }
        return realInjected;
    }

    protected int addToSlot(IInvSlot slot, ItemStack stack, int injected, boolean doAdd) {
        int available = stack.field_77994_a - injected;
        int max = Math.min(stack.func_77976_d(), this.inventory.func_70297_j_());
        ItemStack stackInSlot = slot.getStackInSlot();
        if (stackInSlot == null) {
            int wanted = Math.min(available, max);
            if (doAdd) {
                stackInSlot = stack.func_77946_l();
                stackInSlot.field_77994_a = wanted;
                slot.setStackInSlot(stackInSlot);
            }
            return wanted;
        }
        if (!StackHelper.canStacksMerge(stack, stackInSlot)) {
            return 0;
        }
        int wanted = max - stackInSlot.field_77994_a;
        if (wanted <= 0) {
            return 0;
        }
        if (wanted > available) {
            wanted = available;
        }
        if (doAdd) {
            stackInSlot.field_77994_a += wanted;
            slot.setStackInSlot(stackInSlot);
        }
        return wanted;
    }

    @Override
    public ItemStack remove(IStackFilter filter, EnumFacing orientation, boolean doRemove) {
        for (IInvSlot slot : InventoryIterator.getIterable(this.inventory, orientation)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack)) continue;
            if (doRemove) {
                return slot.decreaseStackInSlot(1);
            }
            ItemStack output = stack.func_77946_l();
            output.field_77994_a = 1;
            return output;
        }
        return null;
    }
}

