/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.network.base.Packet;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PacketGuiWidget
extends Packet {
    private byte windowId;
    private byte widgetId;
    private byte[] payload;

    public PacketGuiWidget() {
    }

    public PacketGuiWidget(int windowId, int widgetId, byte[] data) {
        this.windowId = (byte)windowId;
        this.widgetId = (byte)widgetId;
        this.payload = data;
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        data.writeByte((int)this.windowId);
        data.writeByte((int)this.widgetId);
        data.writeShort(this.payload.length);
        data.writeBytes(this.payload);
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.windowId = data.readByte();
        this.widgetId = data.readByte();
        short length = data.readShort();
        this.payload = new byte[length];
        data.readBytes(this.payload);
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        if (player != null && player.field_71070_bA instanceof BuildCraftContainer && player.field_71070_bA.field_75152_c == this.windowId) {
            ((BuildCraftContainer)player.field_71070_bA).handleWidgetClientData(this.widgetId, this.payload);
        }
    }
}

