/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.api.core.ISerializable;
import buildcraft.core.lib.network.base.Packet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public abstract class PacketUpdate
extends Packet {
    public ISerializable payload;
    protected ByteBuf payloadData;

    public PacketUpdate() {
    }

    public PacketUpdate(ISerializable payload) {
        this.payload = payload;
        this.isChunkDataPacket = true;
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        this.writeIdentificationData(data);
        ByteBuf payloadData = Unpooled.buffer();
        if (this.payload != null) {
            this.payload.writeData(payloadData);
        }
        int readableBytes = payloadData.readableBytes();
        data.writeInt(readableBytes);
        data.writeBytes(payloadData);
    }

    public abstract void writeIdentificationData(ByteBuf var1);

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.readIdentificationData(data);
        int length = data.readInt();
        this.payloadData = Unpooled.copiedBuffer((ByteBuf)data.readBytes(length));
    }

    public abstract void readIdentificationData(ByteBuf var1);
}

