/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network.base;

import buildcraft.core.lib.network.PacketEntityUpdate;
import buildcraft.core.lib.network.PacketGuiReturn;
import buildcraft.core.lib.network.PacketGuiWidget;
import buildcraft.core.lib.network.PacketSlotChange;
import buildcraft.core.lib.network.PacketTileState;
import buildcraft.core.lib.network.PacketTileUpdate;
import buildcraft.core.lib.network.base.NetworkStatRecorder;
import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.network.base.StatisticsFrame;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.proxy.CoreProxy;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.network.INetHandler;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public final class ChannelHandler
extends FMLIndexedMessageToMessageCodec<Packet> {
    private static boolean recordStats = false;
    private int index = 0;

    public ChannelHandler() {
        this.registerPacketType(PacketTileUpdate.class);
        this.registerPacketType(PacketTileState.class);
        this.registerPacketType(PacketSlotChange.class);
        this.registerPacketType(PacketGuiReturn.class);
        this.registerPacketType(PacketGuiWidget.class);
        this.registerPacketType(PacketCommand.class);
        this.registerPacketType(PacketEntityUpdate.class);
    }

    public void registerPacketType(Class<? extends Packet> type) {
        super.addDiscriminator(this.index++, type);
    }

    public static boolean shouldRecordStats() {
        return recordStats;
    }

    public static void setRecordStats(boolean newValue) {
        if (newValue != recordStats) {
            if (newValue) {
                StatisticsFrame.createStatisticsFrame();
            } else {
                StatisticsFrame.destroyStatisticsFrame();
            }
        }
        recordStats = newValue;
    }

    public ChannelHandler addDiscriminator(int discriminator, Class<? extends Packet> type) {
        throw new IllegalArgumentException("Use registerPacketType instead!");
    }

    public void encodeInto(ChannelHandlerContext ctx, Packet packet, ByteBuf data) throws Exception {
        int start = data.writerIndex();
        packet.writeData(data);
        int written = data.writerIndex() - start;
        this.recordStat(ctx, written, packet, NetworkStatRecorder.EnumOpType.WRITE);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data, Packet packet) {
        int start = data.readerIndex();
        INetHandler handler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        packet.readData(data);
        packet.player = CoreProxy.proxy.getPlayerFromNetHandler(handler);
        int read = data.readerIndex() - start;
        this.recordStat(ctx, read, packet, NetworkStatRecorder.EnumOpType.READ);
    }

    private void recordStat(ChannelHandlerContext ctx, long bytes, Packet packet, NetworkStatRecorder.EnumOpType type) {
        if (ChannelHandler.shouldRecordStats()) {
            NetworkStatRecorder.recordStat(ctx, bytes, packet, type);
        }
    }
}

