/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network.base;

import buildcraft.core.lib.network.base.NetworkStatRecorder;
import buildcraft.core.lib.network.base.Packet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class StatisticsFrame
extends JFrame
implements TreeSelectionListener {
    private static final long serialVersionUID = -6012472823876988075L;
    private static final String[] sizes = new String[]{"", "K", "M", "G", "T"};
    private static final Object INSTANCE_SYNC_OBJ = new Object();
    private static final Object STAT_SYNC_OBJ = new Object();
    static volatile StatisticsFrame instance = null;
    private JPanel contentPane;
    private JTree packetType;
    private JPanel packetGraph;
    private DefaultTreeModel packetTreeModel;
    private final Map<Class<? extends Packet>, PacketNode> nodes = Maps.newHashMap();
    private final Map<NetworkStatRecorder.PacketSource, InfoNode> infoNodes = Maps.newHashMap();
    private final PacketNode rootNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyStatisticsFrame() {
        if (instance == null) {
            return;
        }
        Object object = INSTANCE_SYNC_OBJ;
        synchronized (object) {
            if (instance == null) {
                return;
            }
            instance.dispose();
            instance = null;
        }
    }

    public static void createStatisticsFrame() {
        if (instance != null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = INSTANCE_SYNC_OBJ;
                synchronized (object) {
                    if (instance != null) {
                        return;
                    }
                    try {
                        instance = new StatisticsFrame();
                        instance.updateGraph();
                        instance.setVisible(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        instance = null;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        throw new IllegalStateException(t);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update() {
        if (instance == null) {
            return;
        }
        Object object = INSTANCE_SYNC_OBJ;
        synchronized (object) {
            if (instance == null) {
                return;
            }
            instance.updateGraph();
        }
    }

    static String formatLong(long bytes, boolean useByteSize) {
        double tb = bytes;
        int type = 0;
        while (tb > 800.0) {
            tb /= 1024.0;
            ++type;
        }
        String size = Double.toString(tb);
        if (size.length() > 5) {
            size = size.substring(0, 5);
        }
        return size + " " + sizes[type] + (useByteSize ? "B" : "");
    }

    private StatisticsFrame() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StatisticsFrame.destroyStatisticsFrame();
            }
        });
        this.setTitle("BuildCraft network traffic");
        this.setBounds(100, 100, 450, 300);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.rootNode = new PacketNode(Packet.class, null);
        this.packetTreeModel = new DefaultTreeModel(this.rootNode, true);
        this.packetType = new JTree(this.packetTreeModel);
        this.packetType.addTreeSelectionListener(this);
        this.contentPane.add((Component)this.packetType, "Center");
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.packetType.repaint();
    }

    private PacketNode getPacketNode(Class<? extends Packet> clazz) {
        if (!this.nodes.containsKey(clazz)) {
            if (clazz == Packet.class) {
                this.nodes.put(clazz, this.rootNode);
                return this.rootNode;
            }
            Class<? extends Packet> parentClass = clazz.getSuperclass();
            PacketNode parentNode = this.getPacketNode(parentClass);
            this.nodes.put(clazz, new PacketNode(clazz, parentNode));
        }
        return this.nodes.get(clazz);
    }

    private InfoNode getInfoNode(NetworkStatRecorder.PacketSource source) {
        if (!this.infoNodes.containsKey(source)) {
            this.infoNodes.put(source, new InfoNode(source.extraInfo, this.getPacketNode(source.clazz)));
            this.packetType.revalidate();
            this.packetType.repaint();
        }
        return this.infoNodes.get(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGraph() {
        Object object = STAT_SYNC_OBJ;
        synchronized (object) {
            for (Map.Entry<NetworkStatRecorder.PacketSource, EnumMap<NetworkStatRecorder.EnumOpType, NetworkStatRecorder.PacketStats>> entry : NetworkStatRecorder.packetMap.entrySet()) {
                this.getInfoNode(entry.getKey()).update(entry.getValue());
            }
            this.rootNode.update();
        }
        this.packetType.revalidate();
        this.packetType.repaint();
    }

    private static class InfoNode
    extends BaseNode {
        final String info;

        protected InfoNode(String info, PacketNode parent) {
            super(true, parent);
            this.info = info;
        }

        @Override
        public String toString() {
            return this.info + super.toString();
        }

        void update(EnumMap<NetworkStatRecorder.EnumOpType, NetworkStatRecorder.PacketStats> map) {
            for (Map.Entry<NetworkStatRecorder.EnumOpType, NetworkStatRecorder.PacketStats> entry : map.entrySet()) {
                NetworkStatRecorder.EnumOpType type = entry.getKey();
                int[] packetsTo = (int[])this.packets.get((Object)type);
                long[] bytesTo = (long[])this.bytes.get((Object)type);
                NetworkStatRecorder.PacketStats stats = entry.getValue();
                for (int i = 0; i < 120; ++i) {
                    int from = (i + stats.currentIndex) % 120;
                    int to = (i + index) % 120;
                    packetsTo[to] = stats.packets[from];
                    bytesTo[to] = stats.bytes[from];
                }
                int n = type.ordinal();
                this.totalBytes[n] = this.totalBytes[n] + stats.bytes[stats.getLastIndex()];
                int n2 = type.ordinal();
                this.totalPackets[n2] = this.totalPackets[n2] + stats.packets[stats.getLastIndex()];
            }
        }
    }

    private static class PacketNode
    extends BaseNode {
        final String clazz;

        protected PacketNode(Class<? extends Packet> clazz, PacketNode parent) {
            super(false, parent);
            this.clazz = clazz.getName();
        }

        @Override
        public String toString() {
            return this.clazz + super.toString();
        }

        public void update() {
            EnumMap totalBytes = Maps.newEnumMap(NetworkStatRecorder.EnumOpType.class);
            EnumMap totalPackets = Maps.newEnumMap(NetworkStatRecorder.EnumOpType.class);
            for (NetworkStatRecorder.EnumOpType type : NetworkStatRecorder.EnumOpType.values()) {
                totalBytes.put(type, new long[120]);
                totalPackets.put(type, new int[120]);
            }
            this.totalBytes[1] = 0L;
            this.totalBytes[0] = 0L;
            this.totalPackets[1] = 0;
            this.totalPackets[0] = 0;
            for (BaseNode child : this.children) {
                if (child instanceof PacketNode) {
                    ((PacketNode)child).update();
                }
                for (NetworkStatRecorder.EnumOpType type : NetworkStatRecorder.EnumOpType.values()) {
                    for (int i = 0; i < 120; ++i) {
                        long[] lArray = (long[])totalBytes.get((Object)type);
                        int n = i;
                        lArray[n] = lArray[n] + child.bytes.get((Object)type)[i];
                        int[] nArray = (int[])totalPackets.get((Object)type);
                        int n2 = i;
                        nArray[n2] = nArray[n2] + child.packets.get((Object)type)[i];
                    }
                    int n = type.ordinal();
                    this.totalBytes[n] = this.totalBytes[n] + child.totalBytes[type.ordinal()];
                    int n3 = type.ordinal();
                    this.totalPackets[n3] = this.totalPackets[n3] + child.totalPackets[type.ordinal()];
                }
            }
            this.bytes = totalBytes;
            this.packets = totalPackets;
        }
    }

    private static abstract class BaseNode
    implements TreeNode {
        public static final int HISTORY_SIZE = 120;
        static int index = 0;
        final boolean leaf;
        final BaseNode parent;
        final List<BaseNode> children;
        final long[] totalBytes = new long[2];
        final int[] totalPackets = new int[2];
        volatile EnumMap<NetworkStatRecorder.EnumOpType, long[]> bytes = Maps.newEnumMap(NetworkStatRecorder.EnumOpType.class);
        volatile EnumMap<NetworkStatRecorder.EnumOpType, int[]> packets = Maps.newEnumMap(NetworkStatRecorder.EnumOpType.class);

        protected BaseNode(boolean leaf, BaseNode parent) {
            this.leaf = leaf;
            this.parent = parent;
            this.children = Lists.newArrayList();
            for (NetworkStatRecorder.EnumOpType type : NetworkStatRecorder.EnumOpType.values()) {
                this.bytes.put(type, new long[120]);
                this.packets.put(type, new int[120]);
            }
            if (parent != null) {
                parent.children.add(this);
                instance.packetTreeModel.reload(parent);
            }
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.children.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return !this.leaf;
        }

        @Override
        public boolean isLeaf() {
            return this.leaf;
        }

        public Enumeration children() {
            return Collections.enumeration(this.children);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder builder = new StringBuilder();
            Object object = STAT_SYNC_OBJ;
            synchronized (object) {
                int written = 0;
                for (NetworkStatRecorder.EnumOpType type : NetworkStatRecorder.EnumOpType.values()) {
                    if (this.totalBytes[type.ordinal()] == 0L) continue;
                    builder.append(' ');
                    builder.append(StatisticsFrame.formatLong(this.totalBytes[type.ordinal()], true));
                    builder.append(' ').append(type.operation).append(" over ");
                    builder.append(StatisticsFrame.formatLong(this.totalPackets[type.ordinal()], false));
                    builder.append(" packets");
                    if (written == 0) {
                        builder.append(',');
                    }
                    ++written;
                }
            }
            return builder.toString();
        }
    }
}

