/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network.command;

import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.network.command.CommandTarget;
import buildcraft.core.lib.network.command.CommandTargetContainer;
import buildcraft.core.lib.network.command.CommandTargetEntity;
import buildcraft.core.lib.network.command.CommandTargetTile;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.utils.NetworkUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PacketCommand
extends Packet {
    public static final ArrayList<CommandTarget> targets = new ArrayList();
    public ByteBuf stream;
    public String command;
    public Object target;
    public CommandTarget handler;
    private CommandWriter writer;

    public PacketCommand() {
    }

    public PacketCommand(Object target, String command, CommandWriter writer) {
        this.target = target;
        this.command = command;
        this.writer = writer;
        this.isChunkDataPacket = true;
        for (CommandTarget c : targets) {
            if (!c.getHandledClass().isAssignableFrom(target.getClass())) continue;
            this.handler = c;
            break;
        }
        this.tempWorld = this.handler.getWorld(target);
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        NetworkUtils.writeUTF(data, this.command);
        data.writeByte(targets.indexOf(this.handler));
        this.handler.write(data, this.target);
        if (this.writer != null) {
            this.writer.write(data);
        }
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.command = NetworkUtils.readUTF(data);
        this.handler = targets.get(data.readUnsignedByte());
        this.stream = data;
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        ICommandReceiver receiver;
        if (this.handler != null && (receiver = this.handler.handle(player, this.stream, world)) != null) {
            receiver.receiveCommand(this.command, FMLCommonHandler.instance().getEffectiveSide(), player, this.stream);
        }
    }

    static {
        targets.add(new CommandTargetTile());
        targets.add(new CommandTargetEntity());
        targets.add(new CommandTargetContainer());
    }
}

