/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.render;

import buildcraft.core.lib.render.PerspAwareModelBase;
import buildcraft.core.lib.utils.MatrixUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IColoredBakedQuad;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.TRSRTransformation;
import org.apache.commons.lang3.ArrayUtils;

public class BuildCraftBakedModel
extends PerspAwareModelBase {
    public static final int U_MIN = 0;
    public static final int U_MAX = 1;
    public static final int V_MIN = 2;
    public static final int V_MAX = 3;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int SHADE = 3;
    public static final int U = 4;
    public static final int V = 5;
    public static final int UNUSED = 6;
    public static final int ARRAY_SIZE = 7;

    public BuildCraftBakedModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
        super(format, quads, particle, transforms);
    }

    public BuildCraftBakedModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format) {
        this(quads, particle, format, BuildCraftBakedModel.getBlockTransforms());
    }

    protected static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getBlockTransforms() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.09375f, -0.171875f), TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(10.0f, -45.0f, 170.0f)), new Vector3f(0.375f, 0.375f, 0.375f), null)));
        Matrix4f rotationMatrix = new Matrix4f();
        rotationMatrix.setIdentity();
        rotationMatrix = MatrixUtils.rotateTowardsFace(EnumFacing.SOUTH, EnumFacing.EAST);
        Matrix4f result = new Matrix4f();
        result.setIdentity();
        result.mul(rotationMatrix);
        TRSRTransformation trsr = new TRSRTransformation(result);
        builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)trsr);
        return builder.build();
    }

    protected static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getItemTransforms() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        float scale = 0.375f;
        Vector3f translation = new Vector3f(0.0f, 1.5f * scale, -2.75f * scale);
        TRSRTransformation trsr = new TRSRTransformation(translation, new Quat4f(10.0f, -45.0f, 170.0f, 1.0f), new Vector3f(0.375f, 0.375f, 0.375f), null);
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON, (Object)trsr);
        translation = new Vector3f(1.0f, 1.0f, 0.0f);
        trsr = new TRSRTransformation(translation, new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, -90.0f, 90.0f, 1.0f));
        builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)trsr);
        return builder.build();
    }

    protected static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getPluggableTransforms() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Quat4f rotation = TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(10.0f, -45.0f, 170.0f));
        TRSRTransformation trsr = new TRSRTransformation(new Vector3f(0.0f, 0.09375f, -0.171875f), rotation, new Vector3f(0.375f, 0.375f, 0.375f), null);
        trsr = TRSRTransformation.blockCenterToCorner((TRSRTransformation)trsr);
        Matrix4f trsrMatrix = trsr.getMatrix();
        Matrix4f result = new Matrix4f();
        result.setIdentity();
        Matrix4f rotationMatrix = new Matrix4f();
        rotationMatrix.setIdentity();
        rotationMatrix = MatrixUtils.rotateTowardsFace(EnumFacing.SOUTH, EnumFacing.NORTH);
        result.mul(trsrMatrix);
        result.mul(rotationMatrix);
        trsr = new TRSRTransformation(result);
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON, (Object)trsr);
        Matrix4f rotationMatrix2 = new Matrix4f();
        rotationMatrix2.setIdentity();
        rotationMatrix2 = MatrixUtils.rotateTowardsFace(EnumFacing.SOUTH, EnumFacing.EAST);
        Matrix4f result2 = new Matrix4f();
        result2.setIdentity();
        result2.mul(rotationMatrix2);
        TRSRTransformation trsr2 = new TRSRTransformation(result2);
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON, (Object)trsr2);
        return builder.build();
    }

    public static int[][] getDoubleFrom(Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, float[] uvs) {
        int[][] arr = new int[2][];
        arr[0] = BuildCraftBakedModel.getFrom(p1, p2, p3, p4, uvs);
        float[] duvs = new float[]{uvs[1], uvs[0], uvs[2], uvs[3]};
        arr[1] = BuildCraftBakedModel.getFrom(p4, p3, p2, p1, duvs);
        return arr;
    }

    public static int[][] getDoubleFrom(Vector3f[] array, float[] uvs) {
        return BuildCraftBakedModel.getDoubleFrom(array[0], array[1], array[2], array[3], uvs);
    }

    public static int[] getFrom(Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, float[] uvs) {
        int[] i1 = new int[]{BuildCraftBakedModel.asInt(p1.x), BuildCraftBakedModel.asInt(p1.y), BuildCraftBakedModel.asInt(p1.z), -1, BuildCraftBakedModel.asInt(uvs[0]), BuildCraftBakedModel.asInt(uvs[2]), 0};
        int[] i2 = new int[]{BuildCraftBakedModel.asInt(p2.x), BuildCraftBakedModel.asInt(p2.y), BuildCraftBakedModel.asInt(p2.z), -1, BuildCraftBakedModel.asInt(uvs[0]), BuildCraftBakedModel.asInt(uvs[3]), 0};
        int[] i3 = new int[]{BuildCraftBakedModel.asInt(p3.x), BuildCraftBakedModel.asInt(p3.y), BuildCraftBakedModel.asInt(p3.z), -1, BuildCraftBakedModel.asInt(uvs[1]), BuildCraftBakedModel.asInt(uvs[3]), 0};
        int[] i4 = new int[]{BuildCraftBakedModel.asInt(p4.x), BuildCraftBakedModel.asInt(p4.y), BuildCraftBakedModel.asInt(p4.z), -1, BuildCraftBakedModel.asInt(uvs[1]), BuildCraftBakedModel.asInt(uvs[2]), 0};
        return BuildCraftBakedModel.concat(i1, i2, i3, i4);
    }

    public static float[] getUVArray(TextureAtlasSprite sprite) {
        float[] uvs = new float[]{sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h()};
        return uvs;
    }

    public static int[] getFrom(Vector3f[] array, float[] uvs) {
        return BuildCraftBakedModel.getFrom(array[0], array[1], array[2], array[3], uvs);
    }

    public static int asInt(float f) {
        return Float.floatToRawIntBits(f);
    }

    public static int[] concat(int[] ... ints) {
        int[] holder = ints[0];
        for (int i = 1; i < ints.length; ++i) {
            holder = ArrayUtils.addAll((int[])holder, (int[])ints[i]);
        }
        return holder;
    }

    public static void bakeQuad(List<BakedQuad> quads, int[] list, EnumFacing side) {
        quads.add(new BakedQuad(list, -1, side));
    }

    public static void bakeQuads(List<BakedQuad> quads, int[][] lists, EnumFacing ... sides) {
        for (int i = 0; i < lists.length; ++i) {
            BuildCraftBakedModel.bakeQuad(quads, lists[i], sides[i]);
        }
    }

    public static Vector3f[] getPoints(Vector3f centerFace, Vector3f faceRadius) {
        Vector3f[] array = new Vector3f[]{new Vector3f(centerFace), new Vector3f(centerFace), new Vector3f(centerFace), new Vector3f(centerFace)};
        array[0].add((Tuple3f)BuildCraftBakedModel.addOrNegate(faceRadius, false, false));
        array[1].add((Tuple3f)BuildCraftBakedModel.addOrNegate(faceRadius, false, true));
        array[2].add((Tuple3f)BuildCraftBakedModel.addOrNegate(faceRadius, true, true));
        array[3].add((Tuple3f)BuildCraftBakedModel.addOrNegate(faceRadius, true, false));
        return array;
    }

    public static Vector3f addOrNegate(Vector3f coord, boolean u, boolean v) {
        boolean zisv = coord.x != 0.0f && coord.y == 0.0f;
        Vector3f neg = new Vector3f(coord.x * (float)(u ? 1 : -1), coord.y * (float)(v ? -1 : 1), coord.z * (float)(zisv ? (v ? -1 : 1) : (u ? 1 : -1)));
        return neg;
    }

    public static void bakeFace(List<BakedQuad> quads, EnumFacing face, Vector3f center, Vector3f radius, float[] uvs) {
        Vector3f[] points = BuildCraftBakedModel.getPointsForFace(face, center, radius);
        int[] quadData = BuildCraftBakedModel.getFrom(points, uvs);
        BuildCraftBakedModel.bakeQuad(quads, quadData, face);
    }

    public static void bakeDoubleFace(List<BakedQuad> quads, EnumFacing face, Vector3f center, Vector3f radius, float[] uvs) {
        Vector3f[] points = BuildCraftBakedModel.getPointsForFace(face, center, radius);
        int[][] quadData = BuildCraftBakedModel.getDoubleFrom(points, uvs);
        BuildCraftBakedModel.bakeQuads(quads, quadData, face.func_176734_d(), face);
    }

    public static Vector3f[] getPointsForFace(EnumFacing face, Vector3f center, Vector3f radius) {
        Vector3f centerOfFace = new Vector3f(center);
        Vector3f faceAdd = new Vector3f((float)face.func_82601_c() * radius.x, (float)face.func_96559_d() * radius.y, (float)face.func_82599_e() * radius.z);
        centerOfFace.add((Tuple3f)faceAdd);
        Vector3f faceRadius = new Vector3f(radius);
        if (face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            faceRadius.sub((Tuple3f)faceAdd);
        } else {
            faceRadius.add((Tuple3f)faceAdd);
        }
        return BuildCraftBakedModel.getPoints(centerOfFace, faceRadius);
    }

    public static BakedQuad transform(BakedQuad quad, Matrix4f matrix4f) {
        int[] data = quad.func_178209_a();
        data = Arrays.copyOf(data, data.length);
        boolean colour = quad instanceof IColoredBakedQuad;
        int step = data.length / 4;
        for (int i = 0; i < 4; ++i) {
            Point3f vec = new Point3f();
            vec.x = Float.intBitsToFloat(data[i * step + 0]);
            vec.y = Float.intBitsToFloat(data[i * step + 1]);
            vec.z = Float.intBitsToFloat(data[i * step + 2]);
            matrix4f.transform(vec);
            data[i * step + 0] = Float.floatToRawIntBits(vec.x);
            data[i * step + 1] = Float.floatToRawIntBits(vec.y);
            data[i * step + 2] = Float.floatToRawIntBits(vec.z);
        }
        return colour ? new IColoredBakedQuad.ColoredBakedQuad(data, quad.func_178211_c(), quad.func_178210_d()) : new BakedQuad(data, quad.func_178211_c(), quad.func_178210_d());
    }

    public static BakedQuad replaceShade(BakedQuad quad, int shade) {
        int[] data = quad.func_178209_a();
        int step = data.length / 4;
        data = Arrays.copyOf(data, data.length);
        boolean colour = quad instanceof IColoredBakedQuad;
        for (int i = 0; i < 4; ++i) {
            data[i * step + 3] = shade;
        }
        return colour ? new IColoredBakedQuad.ColoredBakedQuad(data, quad.func_178211_c(), quad.func_178210_d()) : new BakedQuad(data, quad.func_178211_c(), quad.func_178210_d());
    }

    public static BakedQuad replaceTint(BakedQuad quad, int tint) {
        boolean colour = quad instanceof IColoredBakedQuad;
        return colour ? new IColoredBakedQuad.ColoredBakedQuad(quad.func_178209_a(), tint, quad.func_178210_d()) : new BakedQuad(quad.func_178209_a(), tint, quad.func_178210_d());
    }

    public static Vector3f normal(BakedQuad quad) {
        int[] data = quad.func_178209_a();
        int step = data.length / 4;
        data = Arrays.copyOf(data, data.length);
        Point3f[] positions = new Point3f[3];
        for (int i = 0; i < 3; ++i) {
            Point3f vec = new Point3f();
            vec.x = Float.intBitsToFloat(data[i * step + 0]);
            vec.y = Float.intBitsToFloat(data[i * step + 1]);
            vec.z = Float.intBitsToFloat(data[i * step + 2]);
            positions[i] = vec;
        }
        Vector3f a = new Vector3f((Tuple3f)positions[1]);
        a.sub((Tuple3f)positions[0]);
        Vector3f b = new Vector3f((Tuple3f)positions[2]);
        b.sub((Tuple3f)positions[0]);
        Vector3f c = new Vector3f();
        c.cross(a, b);
        return c;
    }

    public static float diffuseLight(Vector3f normal) {
        return BuildCraftBakedModel.diffuseLight(normal.x, normal.y, normal.z);
    }

    public static float diffuseLight(float x, float y, float z) {
        boolean up = y >= 0.0f;
        float xx = x * x;
        float yy = y * y;
        float zz = z * z;
        float t = xx + yy + zz;
        float light = (xx * 0.6f + zz * 0.8f) / t;
        float yyt = yy / t;
        if (!up) {
            yyt = (float)((double)yyt * 0.5);
        }
        return light += yyt;
    }

    public static BakedQuad applyDiffuse(BakedQuad quad) {
        Vector3f normal = BuildCraftBakedModel.normal(quad);
        float diffuse = BuildCraftBakedModel.diffuseLight(normal);
        int diffuseI = (int)(diffuse * 255.0f);
        int shade = -16777216 + diffuseI * 65793;
        return BuildCraftBakedModel.replaceShade(quad, shade);
    }

    public static IBakedModel createModelItemLayer(TextureAtlasSprite sprite) {
        return BuildCraftBakedModel.createModelItemLayer(Lists.newArrayList((Object[])new TextureAtlasSprite[]{sprite}));
    }

    public static IBakedModel createModelItemLayer(final List<TextureAtlasSprite> sprites) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < sprites.size(); ++i) {
            builder.add((Object)new ResourceLocation("buildcraftbakedmodel:spriteindex" + i));
        }
        final ImmutableList locations = builder.build();
        ItemLayerModel model = new ItemLayerModel(locations);
        IFlexibleBakedModel baked = model.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176600_a, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

            public TextureAtlasSprite apply(ResourceLocation input) {
                return (TextureAtlasSprite)sprites.get(locations.indexOf((Object)input));
            }
        });
        Matrix4f itemToEdge = new Matrix4f();
        itemToEdge.setIdentity();
        itemToEdge.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, 1.5707964f));
        Matrix4f translation = new Matrix4f();
        translation.setIdentity();
        translation.setTranslation(new Vector3f(-0.46875f, 0.0f, 1.0f));
        translation.mul(itemToEdge);
        ArrayList quads = Lists.newArrayList();
        for (BakedQuad quad : baked.func_177550_a()) {
            quad = BuildCraftBakedModel.transform(quad, translation);
            quads.add(quad);
        }
        return new BuildCraftBakedModel((ImmutableList<BakedQuad>)ImmutableList.copyOf((Collection)quads), sprites.get(0), DefaultVertexFormats.field_176600_a);
    }

    public static Function<ResourceLocation, TextureAtlasSprite> singleTextureFunction(final TextureAtlasSprite sprite) {
        return new Function<ResourceLocation, TextureAtlasSprite>(){

            public TextureAtlasSprite apply(ResourceLocation input) {
                return sprite;
            }
        };
    }
}

