/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.render;

import buildcraft.core.lib.render.DisplayListHelper;

public class DisplayListStageHelper {
    private final DisplayListHelper[] stages;

    public DisplayListStageHelper(int numStages, IStageGenerator gen) {
        this.stages = new DisplayListHelper[numStages];
        for (int i = 0; i < numStages; ++i) {
            this.stages[i] = new DisplayListHelper(new DisplayListGenerator(i, numStages, gen));
        }
    }

    public void renderStage(float stage) {
        if (stage < 0.0f) {
            stage = 0.0f;
        } else if (stage > 1.0f) {
            stage = 1.0f;
        }
        int index = (int)(stage * (float)(this.stages.length - 1));
        this.stages[index].render();
    }

    public void delete() {
        for (DisplayListHelper vboHelper : this.stages) {
            vboHelper.delete();
        }
    }

    public static final class DisplayListGenerator
    implements DisplayListHelper.IGenerator {
        final float stage;
        final IStageGenerator gen;

        public DisplayListGenerator(int stage, int numStages, IStageGenerator gen) {
            this.stage = (float)stage / (float)(numStages - 1);
            this.gen = gen;
        }

        @Override
        public void generate() {
            this.gen.generate(this.stage);
        }
    }

    public static interface IStageGenerator {
        public void generate(float var1);
    }
}

