/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.render;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DynamicTextureBC {
    public final int width;
    public final int height;
    public int[] colorMap;
    @SideOnly(value=Side.CLIENT)
    protected DynamicTexture dynamicTexture;

    public DynamicTextureBC(int iWidth, int iHeight) {
        this.width = iWidth;
        this.height = iHeight;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.createDynamicTexture();
        } else {
            this.colorMap = new int[iWidth * iHeight];
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void createDynamicTexture() {
        this.dynamicTexture = new DynamicTexture(this.width, this.height);
        this.colorMap = this.dynamicTexture.func_110565_c();
    }

    public void setColord(int index, double r, double g, double b, double a) {
        int i = (int)(a * 255.0);
        int j = (int)(r * 255.0);
        int k = (int)(g * 255.0);
        int l = (int)(b * 255.0);
        this.colorMap[index] = i << 24 | j << 16 | k << 8 | l;
    }

    public void setColord(int x, int y, double r, double g, double b, double a) {
        this.setColord(x + y * this.width, r, g, b, a);
    }

    public void setColori(int index, int r, int g, int b, int a) {
        this.colorMap[index] = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public void setColori(int x, int y, int r, int g, int b, int a) {
        this.setColori(x + y * this.width, r, g, b, a);
    }

    public void setColor(int x, int y, int color) {
        this.colorMap[x + y * this.width] = color;
    }

    public void setColor(int x, int y, int color, float alpha) {
        int a = (int)(alpha * 255.0f);
        this.colorMap[x + y * this.width] = a << 24 | color;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTexture() {
        this.dynamicTexture.func_110564_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int screenX, int screenY, float zLevel) {
        this.draw(screenX, screenY, zLevel, 0, 0, this.width, this.height);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int screenX, int screenY, float zLevel, int clipX, int clipY, int clipWidth, int clipHeight) {
        this.updateTexture();
        float f = 1.0f / (float)this.width;
        float f1 = 1.0f / (float)this.height;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer wr = tessellator.func_178180_c();
        wr.func_181668_a(7, wr.func_178973_g());
        this.vertexUV(wr, screenX + 0, screenY + clipHeight, zLevel, (float)(clipX + 0) * f, (float)(clipY + clipHeight) * f1);
        this.vertexUV(wr, screenX + clipWidth, screenY + clipHeight, zLevel, (float)(clipX + clipWidth) * f, (float)(clipY + clipHeight) * f1);
        this.vertexUV(wr, screenX + clipWidth, screenY + 0, zLevel, (float)(clipX + clipWidth) * f, (float)(clipY + 0) * f1);
        this.vertexUV(wr, screenX + 0, screenY + 0, zLevel, (float)(clipX + 0) * f, (float)(clipY + 0) * f1);
        tessellator.func_78381_a();
    }

    private void vertexUV(WorldRenderer wr, double x, double y, double z, double u, double v) {
        wr.func_181662_b(x, y, z);
        wr.func_181673_a(u, v);
        wr.func_181675_d();
    }
}

