/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.render;

import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.render.RenderResizableCuboid;
import buildcraft.core.lib.render.RenderUtils;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public final class FluidRenderer {
    public static final int DISPLAY_STAGES = 100;
    public static final Vec3 BLOCK_SIZE = new Vec3(0.98, 0.98, 0.98);
    private static Map<Fluid, Map<Vec3, int[]>> flowingRenderCache = Maps.newHashMap();
    private static Map<Fluid, Map<Vec3, int[]>> stillRenderCache = Maps.newHashMap();
    private static Map<FluidType, Map<Fluid, TextureAtlasSprite>> textureMap = Maps.newHashMap();
    private static TextureAtlasSprite missingIcon = null;

    private FluidRenderer() {
    }

    public static void initFluidTextures(TextureMap map) {
        missingIcon = map.func_174944_f();
        textureMap.clear();
        for (FluidType type : FluidType.values()) {
            textureMap.put(type, new HashMap());
        }
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            TextureAtlasSprite sprite;
            if (fluid.getFlowing() != null) {
                String flow = fluid.getFlowing().toString();
                sprite = map.getTextureExtry(flow) != null ? map.getTextureExtry(flow) : map.func_174942_a(fluid.getStill());
                textureMap.get((Object)FluidType.FLOWING).put(fluid, sprite);
            }
            if (fluid.getStill() == null) continue;
            String still = fluid.getStill().toString();
            sprite = map.getTextureExtry(still) != null ? map.getTextureExtry(still) : map.func_174942_a(fluid.getStill());
            textureMap.get((Object)FluidType.STILL).put(fluid, sprite);
        }
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack stack, FluidType type) {
        if (stack == null) {
            return missingIcon;
        }
        return FluidRenderer.getFluidTexture(stack.getFluid(), type);
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid, FluidType type) {
        if (fluid == null || type == null) {
            return missingIcon;
        }
        Map<Fluid, TextureAtlasSprite> map = textureMap.get((Object)type);
        return map.containsKey(fluid) ? map.get(fluid) : missingIcon;
    }

    @Deprecated
    public static TextureAtlasSprite getFluidTexture(FluidStack fluidStack, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        return FluidRenderer.getFluidTexture(fluidStack.getFluid(), flowing);
    }

    @Deprecated
    public static TextureAtlasSprite getFluidTexture(Fluid fluid, boolean flowing) {
        return FluidRenderer.getFluidTexture(fluid, flowing ? FluidType.FLOWING : FluidType.STILL);
    }

    public static void setColorForFluidStack(FluidStack fluidstack) {
        if (fluidstack == null) {
            return;
        }
        int color = fluidstack.getFluid().getColor(fluidstack);
        RenderUtils.setGLColorFromInt(color);
    }

    public static int[] getFluidDisplayLists(FluidStack fluidStack, boolean flowing) {
        return FluidRenderer.getFluidDisplayLists(fluidStack, flowing, BLOCK_SIZE);
    }

    public static int[] getFluidDisplayListForSide(FluidStack fluidStack, boolean flowing, Vec3 size, EnumFacing side) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        int[] lists = new int[100];
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        GlStateManager.func_179129_p();
        for (int s = 0; s < 100; ++s) {
            lists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)lists[s], (int)4864);
            EntityResizableCuboid ent = new EntityResizableCuboid(null);
            ent.xSize = size.field_72450_a;
            ent.ySize = (double)((float)Math.max(s, 1) / 100.0f) * size.field_72448_b;
            ent.zSize = size.field_72449_c;
            ent.texture = FluidRenderer.getFluidTexture(fluidStack, flowing);
            ent.makeClient();
            Arrays.fill(ent.textures, null);
            ent.textures[side.ordinal()] = ent.texture;
            RenderResizableCuboid.INSTANCE.renderCube(ent);
            GL11.glEndList();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        return lists;
    }

    public static int[] getFluidDisplayLists(FluidStack fluidStack, boolean flowing, Vec3 size) {
        int[] displayList;
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map<Fluid, Map<Vec3, int[]>> cache = flowing ? flowingRenderCache : stillRenderCache;
        HashMap displayLists = cache.get(fluid);
        if (displayLists != null) {
            displayList = (int[])displayLists.get(size);
            if (displayList != null) {
                return displayList;
            }
        } else {
            displayLists = Maps.newHashMap();
            cache.put(fluid, displayLists);
        }
        displayList = new int[100];
        cache.put(fluid, displayLists);
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        GlStateManager.func_179129_p();
        for (int s = 0; s < 100; ++s) {
            displayList[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)displayList[s], (int)4864);
            EntityResizableCuboid ent = new EntityResizableCuboid(null);
            ent.xSize = size.field_72450_a;
            ent.ySize = (double)((float)Math.max(s, 1) / 100.0f) * size.field_72448_b;
            ent.zSize = size.field_72449_c;
            ent.texture = FluidRenderer.getFluidTexture(fluidStack, flowing);
            RenderResizableCuboid.INSTANCE.renderCube(ent);
            GL11.glEndList();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        displayLists.put(size, displayList);
        return displayList;
    }

    public static enum FluidType {
        FLOWING,
        STILL,
        FROZEN;

    }
}

