/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.render;

import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.render.FacingRotationHelper;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.core.lib.utils.Utils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderResizableCuboid
extends Render<EntityResizableCuboid> {
    public static final RenderResizableCuboid INSTANCE = new RenderResizableCuboid();
    private static final Map<EnumFacing, Vec3> aoMap = Maps.newEnumMap(EnumFacing.class);
    private static final int U_MIN = 0;
    private static final int U_MAX = 1;
    private static final int V_MIN = 2;
    private static final int V_MAX = 3;

    protected RenderResizableCuboid() {
        super(Minecraft.func_71410_x().func_175598_ae());
    }

    protected ResourceLocation getEntityTexture(EntityResizableCuboid entity) {
        return null;
    }

    public boolean shouldRender(EntityResizableCuboid entity, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    public void doRender(EntityResizableCuboid entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        final Vec3 entPos = Utils.getInterpolatedVec(entity, partialTicks);
        IBlockLocation formula = new IBlockLocation(){

            @Override
            public Vec3 transformToWorld(Vec3 vec) {
                return entPos.func_178787_e(vec);
            }
        };
        this.renderCube(entity, EnumShadeArgument.FACE_LIGHT, formula, null);
        GL11.glPopMatrix();
    }

    public void renderCubeFromCentre(EntityResizableCuboid cuboid) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-cuboid.xSize / 2.0), (double)(-cuboid.ySize / 2.0), (double)(-cuboid.zSize / 2.0));
        this.renderCube(cuboid, EnumShadeArgument.NONE, null, null);
        GL11.glPopMatrix();
    }

    public void renderCube(EntityResizableCuboid cuboid) {
        this.renderCube(cuboid, EnumShadeArgument.NONE, null, null);
    }

    public void renderCube(EntityResizableCuboid cube, EnumShadeArgument shadeTypes, IBlockLocation formula, IFacingLocation faceFormula) {
        int[] flips;
        TextureAtlasSprite[] sprites;
        if (faceFormula == null) {
            faceFormula = DefaultFacingLocation.INSTANCE;
        }
        if ((sprites = cube.textures) == null) {
            sprites = new TextureAtlasSprite[6];
            for (int i = 0; i < 6; ++i) {
                sprites[i] = cube.texture;
            }
        }
        if ((flips = cube.textureFlips) == null) {
            flips = new int[6];
        }
        Vec3 textureStart = new Vec3(cube.textureStartX / 16.0, cube.textureStartY / 16.0, cube.textureStartZ / 16.0);
        Vec3 textureSize = new Vec3(cube.textureSizeX / 16.0, cube.textureSizeY / 16.0, cube.textureSizeZ / 16.0);
        Vec3 textureOffset = new Vec3(cube.textureOffsetX / 16.0, cube.textureOffsetY / 16.0, cube.textureOffsetZ / 16.0);
        Vec3 size = new Vec3(cube.xSize, cube.ySize, cube.zSize);
        this.func_110776_a(cube.resource == null ? TextureMap.field_110575_b : cube.resource);
        Tessellator tess = Tessellator.func_178181_a();
        WorldRenderer wr = tess.func_178180_c();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179140_f();
        wr.func_181668_a(7, shadeTypes.vertexFormat);
        for (EnumFacing face : EnumFacing.values()) {
            this.renderCuboidFace(wr, face, sprites, flips, textureStart, textureSize, size, textureOffset, shadeTypes, formula, faceFormula, (IBlockAccess)cube.field_70170_p);
        }
        tess.func_78381_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179145_e();
        GlStateManager.func_179127_m();
    }

    private void renderCuboidFace(WorldRenderer wr, EnumFacing face, TextureAtlasSprite[] sprites, int[] flips, Vec3 textureStart, Vec3 textureSize, Vec3 size, Vec3 textureOffset, EnumShadeArgument shadeTypes, IBlockLocation locationFormula, IFacingLocation faceFormula, IBlockAccess access) {
        int ordinal = face.ordinal();
        if (sprites[ordinal] == null) {
            return;
        }
        Vec3 textureEnd = textureStart.func_178787_e(textureSize);
        float[] uv = this.getUVArray(sprites[ordinal], flips[ordinal], face, textureStart, textureEnd);
        List<RenderInfo> renderInfoList = this.getRenderInfos(uv, face, size, textureSize, textureOffset);
        EnumFacing.Axis u = face.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
        EnumFacing.Axis v = face.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.Axis.Z : EnumFacing.Axis.Y;
        double other = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? Utils.getValue(size, face.func_176740_k()) : 0.0;
        face = face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? face : face.func_176734_d();
        EnumFacing opposite = face.func_176734_d();
        for (RenderInfo ri : renderInfoList) {
            this.renderPoint(wr, face, u, v, other, ri, true, false, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, face, u, v, other, ri, true, true, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, face, u, v, other, ri, false, true, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, face, u, v, other, ri, false, false, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, opposite, u, v, other, ri, false, false, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, opposite, u, v, other, ri, false, true, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, opposite, u, v, other, ri, true, true, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, opposite, u, v, other, ri, true, false, locationFormula, faceFormula, access, shadeTypes);
        }
    }

    private void renderPoint(WorldRenderer wr, EnumFacing face, EnumFacing.Axis u, EnumFacing.Axis v, double other, RenderInfo ri, boolean minU, boolean minV, IBlockLocation locationFormula, IFacingLocation faceFormula, IBlockAccess access, EnumShadeArgument shadeTypes) {
        int U_ARRAY = minU ? 0 : 1;
        int V_ARRAY = minV ? 2 : 3;
        Vec3 vertex = Utils.withValue(Utils.VEC_ZERO, u, ri.xyz[U_ARRAY]);
        vertex = Utils.withValue(vertex, v, ri.xyz[V_ARRAY]);
        vertex = Utils.withValue(vertex, face.func_176740_k(), other);
        wr.func_181662_b(vertex.field_72450_a, vertex.field_72448_b, vertex.field_72449_c);
        wr.func_181673_a((double)ri.uv[U_ARRAY], (double)ri.uv[V_ARRAY]);
        if (shadeTypes.isEnabled(EnumShadeType.FACE)) {
            RenderUtils.setWorldRendererRGB(wr, aoMap.get(faceFormula.transformToWorld(face)));
        }
        if (shadeTypes.isEnabled(EnumShadeType.AMBIENT_OCCLUSION)) {
            this.applyLocalAO(wr, faceFormula.transformToWorld(face), locationFormula, access, shadeTypes, vertex);
        } else if (shadeTypes.isEnabled(EnumShadeType.LIGHT)) {
            Vec3 transVertex = locationFormula.transformToWorld(vertex);
            BlockPos pos = Utils.convertFloor(transVertex);
            Block block = access.func_180495_p(pos).func_177230_c();
            int combindedLight = block.func_176207_c(access, pos);
            wr.func_181671_a(combindedLight >> 16 & 0xFFFF, combindedLight & 0xFFFF);
        }
        wr.func_181675_d();
    }

    private void applyLocalAO(WorldRenderer wr, EnumFacing face, IBlockLocation locationFormula, IBlockAccess access, EnumShadeArgument shadeTypes, Vec3 vertex) {
        EnumFacing[] testArray;
        boolean allAround = false;
        int numPositions = allAround ? 7 : 5;
        int[] skyLight = new int[numPositions];
        int[] blockLight = new int[numPositions];
        float[] colorMultiplier = new float[numPositions];
        double[] distances = new double[numPositions];
        double totalDist = 0.0;
        Vec3 transVertex = locationFormula.transformToWorld(vertex);
        BlockPos pos = Utils.convertFloor(transVertex);
        Block block = access.func_180495_p(pos).func_177230_c();
        int combindedLight = block.func_176207_c(access, pos);
        skyLight[0] = combindedLight / 65536;
        blockLight[0] = combindedLight % 65536;
        colorMultiplier[0] = block.func_149685_I();
        distances[0] = transVertex.func_72438_d(Utils.convertMiddle((Vec3i)pos));
        int index = 0;
        for (EnumFacing otherFace : testArray = allAround ? EnumFacing.values() : Utils.getNeighbours(face)) {
            Vec3 nearestOther = vertex.func_178787_e(Utils.convert(otherFace));
            pos = Utils.convertFloor(locationFormula.transformToWorld(nearestOther));
            block = access.func_180495_p(pos).func_177230_c();
            combindedLight = block.func_176207_c(access, pos);
            skyLight[++index] = combindedLight / 65536;
            blockLight[index] = combindedLight % 65536;
            colorMultiplier[index] = block.func_149685_I();
            distances[index] = 1.0 / (transVertex.func_72438_d(Utils.convertMiddle((Vec3i)pos)) + 0.1);
            totalDist += distances[index];
        }
        double avgBlockLight = 0.0;
        double avgSkyLight = 0.0;
        float avgColorMultiplier = 0.0f;
        for (int i = 0; i < numPositions; ++i) {
            double part = distances[i] / totalDist;
            avgBlockLight += (double)blockLight[i] * part;
            avgSkyLight += (double)skyLight[i] * part;
            avgColorMultiplier = (float)((double)avgColorMultiplier + (double)colorMultiplier[i] * part);
        }
        if (shadeTypes.isEnabled(EnumShadeType.LIGHT)) {
            int capBlockLight = (int)avgBlockLight;
            int capSkyLight = (int)avgSkyLight;
            wr.func_181671_a(capBlockLight, capSkyLight);
        }
        Vec3 color = shadeTypes.isEnabled(EnumShadeType.FACE) ? aoMap.get(face) : Utils.VEC_ONE;
        color = Utils.multiply(color, avgColorMultiplier);
        RenderUtils.setWorldRendererRGB(wr, color);
    }

    public void renderCubeStatic(List<BakedQuad> quads, EntityResizableCuboid cuboid) {
        double[][] arr;
        float[] uv;
        int[] flips;
        TextureAtlasSprite[] sprites = cuboid.textures;
        if (sprites == null) {
            sprites = new TextureAtlasSprite[6];
            for (int i = 0; i < 6; ++i) {
                sprites[i] = cuboid.texture;
            }
        }
        if ((flips = cuboid.textureFlips) == null) {
            flips = new int[6];
        }
        double textureStartX = cuboid.textureStartX / 16.0;
        double textureStartY = cuboid.textureStartY / 16.0;
        double textureStartZ = cuboid.textureStartZ / 16.0;
        double textureSizeX = cuboid.textureSizeX / 16.0;
        double textureSizeY = cuboid.textureSizeY / 16.0;
        double textureSizeZ = cuboid.textureSizeZ / 16.0;
        double textureEndX = textureSizeX + textureStartX;
        double textureEndY = textureSizeY + textureStartY;
        double textureEndZ = textureSizeZ + textureStartZ;
        double textureOffsetX = cuboid.textureOffsetX / 16.0;
        double textureOffsetY = cuboid.textureOffsetY / 16.0;
        double textureOffsetZ = cuboid.textureOffsetZ / 16.0;
        double sizeX = cuboid.xSize;
        double sizeY = cuboid.ySize;
        double sizeZ = cuboid.zSize;
        if (sprites[0] != null) {
            uv = this.getUVArray(sprites[0], flips[0], textureStartX, textureEndX, textureStartZ, textureEndZ);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeX, sizeZ, textureSizeX, textureSizeZ, textureOffsetX, textureOffsetZ)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.Y);
                arr = new double[][]{{ri.xyz[1], cuboid.field_70163_u, ri.xyz[2], -1.0, ri.uv[1], ri.uv[2], 0.0}, {ri.xyz[1], cuboid.field_70163_u, ri.xyz[3], -1.0, ri.uv[1], ri.uv[3], 0.0}, {ri.xyz[0], cuboid.field_70163_u, ri.xyz[3], -1.0, ri.uv[0], ri.uv[3], 0.0}, {ri.xyz[0], cuboid.field_70163_u, ri.xyz[2], -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.DOWN);
            }
        }
        if (sprites[1] != null) {
            uv = this.getUVArray(sprites[1], flips[1], textureStartX, textureEndX, textureStartZ, textureEndZ);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeX, sizeZ, textureSizeX, textureSizeZ, textureOffsetX, textureOffsetZ)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.Y);
                arr = new double[][]{{ri.xyz[1], sizeY + cuboid.field_70163_u, ri.xyz[2], -1.0, ri.uv[1], ri.uv[2], 0.0}, {ri.xyz[1], sizeY + cuboid.field_70163_u, ri.xyz[3], -1.0, ri.uv[1], ri.uv[3], 0.0}, {ri.xyz[0], sizeY + cuboid.field_70163_u, ri.xyz[3], -1.0, ri.uv[0], ri.uv[3], 0.0}, {ri.xyz[0], sizeY + cuboid.field_70163_u, ri.xyz[2], -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.UP);
            }
        }
        if (sprites[2] != null) {
            uv = this.getUVArray(sprites[2], flips[2], textureStartX, textureEndX, textureStartY, textureEndY);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeX, sizeY, textureSizeX, textureSizeY, textureOffsetX, textureOffsetY)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.Z);
                arr = new double[][]{{ri.xyz[1], ri.xyz[2], cuboid.field_70161_v, -1.0, ri.uv[1], ri.uv[2], 0.0}, {ri.xyz[1], ri.xyz[3], cuboid.field_70161_v, -1.0, ri.uv[1], ri.uv[3], 0.0}, {ri.xyz[0], ri.xyz[3], cuboid.field_70161_v, -1.0, ri.uv[0], ri.uv[3], 0.0}, {ri.xyz[0], ri.xyz[2], cuboid.field_70161_v, -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.NORTH);
            }
        }
        if (sprites[3] != null) {
            uv = this.getUVArray(sprites[3], flips[3], textureStartX, textureEndX, textureStartY, textureEndY);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeX, sizeY, textureSizeX, textureSizeY, textureOffsetX, textureOffsetY)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.Z);
                arr = new double[][]{{ri.xyz[1], ri.xyz[2], cuboid.field_70161_v + sizeZ, -1.0, ri.uv[1], ri.uv[2], 0.0}, {ri.xyz[1], ri.xyz[3], cuboid.field_70161_v + sizeZ, -1.0, ri.uv[1], ri.uv[3], 0.0}, {ri.xyz[0], ri.xyz[3], cuboid.field_70161_v + sizeZ, -1.0, ri.uv[0], ri.uv[3], 0.0}, {ri.xyz[0], ri.xyz[2], cuboid.field_70161_v + sizeZ, -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.SOUTH);
            }
        }
        if (sprites[4] != null) {
            uv = this.getUVArray(sprites[4], flips[4], textureStartZ, textureEndZ, textureStartY, textureEndY);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeZ, sizeY, textureSizeZ, textureSizeY, textureOffsetZ, textureOffsetY)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.X);
                arr = new double[][]{{cuboid.field_70165_t, ri.xyz[2], ri.xyz[1], -1.0, ri.uv[1], ri.uv[2], 0.0}, {cuboid.field_70165_t, ri.xyz[3], ri.xyz[1], -1.0, ri.uv[1], ri.uv[3], 0.0}, {cuboid.field_70165_t, ri.xyz[3], ri.xyz[0], -1.0, ri.uv[0], ri.uv[3], 0.0}, {cuboid.field_70165_t, ri.xyz[2], ri.xyz[0], -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.WEST);
            }
        }
        if (sprites[5] != null) {
            uv = this.getUVArray(sprites[5], flips[5], textureStartZ, textureEndZ, textureStartY, textureEndY);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeZ, sizeY, textureSizeZ, textureSizeY, textureOffsetZ, textureOffsetY)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.X);
                arr = new double[][]{{cuboid.field_70165_t + sizeX, ri.xyz[2], ri.xyz[1], -1.0, ri.uv[1], ri.uv[2], 0.0}, {cuboid.field_70165_t + sizeX, ri.xyz[3], ri.xyz[1], -1.0, ri.uv[1], ri.uv[3], 0.0}, {cuboid.field_70165_t + sizeX, ri.xyz[3], ri.xyz[0], -1.0, ri.uv[0], ri.uv[3], 0.0}, {cuboid.field_70165_t + sizeX, ri.xyz[2], ri.xyz[0], -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.EAST);
            }
        }
    }

    private void convertToDoubleQuads(List<BakedQuad> quads, double[][] points, EnumFacing face) {
        BakedQuad quad = this.convertToQuad(points, face);
        quads.add(quad);
        double[][] otherPoints = new double[][]{points[3], points[2], points[1], points[0]};
        quad = this.convertToQuad(otherPoints, face);
        quads.add(quad);
    }

    private BakedQuad convertToQuad(double[][] points, EnumFacing face) {
        int[] list = new int[points.length * points[0].length];
        for (int i = 0; i < points.length; ++i) {
            double[] arr = points[i];
            for (int j = 0; j < arr.length; ++j) {
                double d = arr[j];
                int used = 0;
                used = j == 3 || j == 6 ? (int)d : Float.floatToRawIntBits((float)d);
                list[i * arr.length + j] = used;
            }
        }
        return new BakedQuad(list, -1, face);
    }

    private float[] getUVArray(TextureAtlasSprite sprite, int flips, double startU, double endU, double startV, double endV) {
        float holder;
        float minU = sprite.func_94214_a(startU * 16.0);
        float maxU = sprite.func_94214_a(endU * 16.0);
        float minV = sprite.func_94207_b(startV * 16.0);
        float maxV = sprite.func_94207_b(endV * 16.0);
        float[] uvarray = new float[]{minU, maxU, minV, maxV};
        if (flips % 2 == 1) {
            holder = uvarray[0];
            uvarray[0] = uvarray[1];
            uvarray[1] = holder;
        }
        if (flips >> 1 == 1) {
            holder = uvarray[2];
            uvarray[2] = uvarray[3];
            uvarray[3] = holder;
        }
        return uvarray;
    }

    private float[] getUVArray(TextureAtlasSprite sprite, int flips, EnumFacing face, Vec3 start, Vec3 end) {
        float holder;
        EnumFacing.Axis u = face.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
        EnumFacing.Axis v = face.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.Axis.Z : EnumFacing.Axis.Y;
        float minU = sprite.func_94214_a(Utils.getValue(start, u) * 16.0);
        float maxU = sprite.func_94214_a(Utils.getValue(end, u) * 16.0);
        float minV = sprite.func_94207_b(Utils.getValue(start, v) * 16.0);
        float maxV = sprite.func_94207_b(Utils.getValue(end, v) * 16.0);
        float[] uvarray = new float[]{minU, maxU, minV, maxV};
        if (flips % 2 == 1) {
            holder = uvarray[0];
            uvarray[0] = uvarray[1];
            uvarray[1] = holder;
        }
        if (flips >> 1 == 1) {
            holder = uvarray[2];
            uvarray[2] = uvarray[3];
            uvarray[3] = holder;
        }
        return uvarray;
    }

    private List<RenderInfo> getRenderInfos(float[] uv, EnumFacing face, Vec3 size, Vec3 texSize, Vec3 texOffset) {
        EnumFacing.Axis u = face.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
        EnumFacing.Axis v = face.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.Axis.Z : EnumFacing.Axis.Y;
        double sizeU = Utils.getValue(size, u);
        double sizeV = Utils.getValue(size, v);
        double textureSizeU = Utils.getValue(texSize, u);
        double textureSizeV = Utils.getValue(texSize, v);
        double textureOffsetU = Utils.getValue(texOffset, u);
        double textureOffsetV = Utils.getValue(texOffset, v);
        return this.getRenderInfos(uv, sizeU, sizeV, textureSizeU, textureSizeV, textureOffsetU, textureOffsetV);
    }

    private List<RenderInfo> getRenderInfos(float[] uv, double sizeU, double sizeV, double textureSizeU, double textureSizeV, double textureOffsetU, double textureOffsetV) {
        ArrayList infos = Lists.newArrayList();
        boolean firstU = true;
        for (double u = 0.0; u < sizeU; u += textureSizeU) {
            float[] uvCu = Arrays.copyOf(uv, 4);
            double addU = textureSizeU;
            boolean lowerU = false;
            if (firstU && textureOffsetU != 0.0) {
                uvCu[0] = uvCu[0] + (uvCu[1] - uvCu[0]) * (float)textureOffsetU;
                addU -= textureOffsetU;
                lowerU = true;
            }
            if (u + addU > sizeU) {
                addU = sizeU - u;
                uvCu[1] = firstU && textureOffsetU != 0.0 ? uvCu[0] + (uvCu[1] - uvCu[0]) * (float)(addU / (textureSizeU - textureOffsetU)) : uvCu[0] + (uvCu[1] - uvCu[0]) * (float)(addU / textureSizeU);
            }
            firstU = false;
            boolean firstV = true;
            for (double v = 0.0; v < sizeV; v += textureSizeV) {
                float[] uvCv = Arrays.copyOf(uvCu, 4);
                double addV = textureSizeV;
                boolean lowerV = false;
                if (firstV && textureOffsetV != 0.0) {
                    uvCv[2] = uvCv[2] + (uvCv[3] - uvCv[2]) * (float)textureOffsetV;
                    addV -= textureOffsetV;
                    lowerV = true;
                }
                if (v + addV > sizeV) {
                    addV = sizeV - v;
                    uvCv[3] = firstV && textureOffsetV != 0.0 ? uvCv[2] + (uvCv[3] - uvCv[2]) * (float)(addV / (textureSizeV - textureOffsetV)) : uvCv[2] + (uvCv[3] - uvCv[2]) * (float)(addV / textureSizeV);
                }
                double[] xyz = new double[]{u, u + addU, v, v + addV};
                infos.add(new RenderInfo(uvCv, xyz));
                if (lowerV) {
                    v -= textureOffsetV;
                }
                firstV = false;
            }
            if (!lowerU) continue;
            u -= textureOffsetU;
        }
        return infos;
    }

    static {
        aoMap.put(EnumFacing.UP, Utils.vec3(1.0));
        aoMap.put(EnumFacing.DOWN, Utils.vec3(0.5));
        aoMap.put(EnumFacing.NORTH, Utils.vec3(0.8));
        aoMap.put(EnumFacing.SOUTH, Utils.vec3(0.8));
        aoMap.put(EnumFacing.EAST, Utils.vec3(0.6));
        aoMap.put(EnumFacing.WEST, Utils.vec3(0.6));
    }

    private static final class RenderInfo {
        private final float[] uv;
        private final double[] xyz;

        public RenderInfo(float[] uv, double[] xyz) {
            this.uv = uv;
            this.xyz = xyz;
        }

        public RenderInfo offset(Entity ent, EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return new RenderInfo(this.uv, new double[]{this.xyz[0] + ent.field_70161_v, this.xyz[1] + ent.field_70161_v, this.xyz[2] + ent.field_70163_u, this.xyz[3] + ent.field_70163_u});
                }
                case Y: {
                    return new RenderInfo(this.uv, new double[]{this.xyz[0] + ent.field_70165_t, this.xyz[1] + ent.field_70165_t, this.xyz[2] + ent.field_70161_v, this.xyz[3] + ent.field_70161_v});
                }
                case Z: {
                    return new RenderInfo(this.uv, new double[]{this.xyz[0] + ent.field_70165_t, this.xyz[1] + ent.field_70165_t, this.xyz[2] + ent.field_70163_u, this.xyz[3] + ent.field_70163_u});
                }
            }
            return new RenderInfo(this.uv, this.xyz);
        }
    }

    public static enum EnumShadeArgument {
        NONE(new EnumShadeType[0]),
        FACE(EnumShadeType.FACE),
        FACE_LIGHT(EnumShadeType.FACE, EnumShadeType.LIGHT),
        FACE_OCCLUDE(EnumShadeType.FACE, EnumShadeType.AMBIENT_OCCLUSION),
        FACE_LIGHT_OCCLUDE(EnumShadeType.FACE, EnumShadeType.LIGHT, EnumShadeType.AMBIENT_OCCLUSION),
        LIGHT(EnumShadeType.LIGHT),
        LIGHT_OCCLUDE(EnumShadeType.LIGHT, EnumShadeType.AMBIENT_OCCLUSION),
        OCCLUDE(EnumShadeType.AMBIENT_OCCLUSION);

        public final ImmutableSet<EnumShadeType> types;
        final VertexFormat vertexFormat = new VertexFormat();

        private EnumShadeArgument(EnumShadeType ... types) {
            this.vertexFormat.func_181721_a(DefaultVertexFormats.field_181713_m);
            this.vertexFormat.func_181721_a(DefaultVertexFormats.field_181715_o);
            for (EnumShadeType type : types) {
                if (this.vertexFormat.func_177343_g().contains(type.element)) continue;
                this.vertexFormat.func_181721_a(type.element);
            }
            this.types = ImmutableSet.copyOf((Object[])types);
        }

        public boolean isEnabled(EnumShadeType type) {
            return this.types.contains((Object)type);
        }
    }

    public static enum EnumShadeType {
        FACE(DefaultVertexFormats.field_181714_n),
        LIGHT(DefaultVertexFormats.field_181716_p),
        AMBIENT_OCCLUSION(DefaultVertexFormats.field_181714_n);

        private final VertexFormatElement element;

        private EnumShadeType(VertexFormatElement element) {
            this.element = element;
        }
    }

    public static class RotatedFacingLocation
    implements IFacingLocation {
        private final FacingRotationHelper helper;
        private final EnumFacing to;

        public RotatedFacingLocation(EnumFacing modelDirection, EnumFacing face) {
            this.helper = FacingRotationHelper.helperForFace(modelDirection);
            this.to = face;
        }

        @Override
        public EnumFacing transformToWorld(EnumFacing face) {
            return this.helper.rotateFace(this.to, face);
        }
    }

    public static enum DefaultFacingLocation implements IFacingLocation
    {
        INSTANCE;


        @Override
        public EnumFacing transformToWorld(EnumFacing face) {
            return face;
        }
    }

    public static interface IFacingLocation {
        public EnumFacing transformToWorld(EnumFacing var1);
    }

    public static interface IBlockLocation {
        public Vec3 transformToWorld(Vec3 var1);
    }
}

