/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.render;

import buildcraft.core.lib.utils.Utils;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public enum RenderUtils {
    INSTANCE;

    private final Map<EnumFacing, Vec3> rotations = Maps.newEnumMap(EnumFacing.class);

    private RenderUtils() {
        this.rotations.put(EnumFacing.UP, Utils.VEC_ZERO);
        this.rotations.put(EnumFacing.DOWN, new Vec3(180.0, 0.0, 0.0));
        EnumFacing face = EnumFacing.SOUTH;
        for (int a = 0; a < 360; a += 90) {
            this.rotations.put(face, new Vec3(90.0, 0.0, (double)a));
            face = face.func_176746_e();
        }
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void setWorldRendererRGB(WorldRenderer wr, Vec3 color) {
        wr.func_181666_a((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, 1.0f);
    }

    public static void addWorldRendererVertex(WorldRenderer wr, Vec3 vertex) {
        wr.func_181662_b(vertex.field_72450_a, vertex.field_72448_b, vertex.field_72449_c);
    }

    public static void putWorldRendererColorMultiplier(WorldRenderer wr, Vec3 color, int index) {
        wr.func_178978_a((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, index);
    }

    public static void translate(Vec3 vector) {
        GL11.glTranslated((double)vector.field_72450_a, (double)vector.field_72448_b, (double)vector.field_72449_c);
    }

    public static void vertex3d(Vec3 vec) {
        GL11.glVertex3d((double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c);
    }

    public static void vertex3f(Vec3 vec) {
        RenderUtils.vertex3f(Utils.convertFloat(vec));
    }

    public static void vertex3f(Vector3f vec) {
        GL11.glVertex3f((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public static void rotate(EnumFacing face) {
        RenderUtils.rotate(RenderUtils.INSTANCE.rotations.get(face));
    }

    public static void rotate(Vec3 rotation) {
        GL11.glRotated((double)rotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
    }
}

