/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.sprite;

import buildcraft.core.lib.sprite.SpriteBuilder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

public class CustomSprite
extends TextureAtlasSprite {
    private final List<SpriteBuilder.ISpriteAction> actions;

    public CustomSprite(String spriteName, List<SpriteBuilder.ISpriteAction> actions) {
        super(spriteName);
        this.actions = actions;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    private static boolean isPowerOfTwo(int p_151235_0_) {
        return p_151235_0_ != 0 && (p_151235_0_ & p_151235_0_ - 1) == 0;
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        int width = MathHelper.func_151239_c((int)16);
        for (SpriteBuilder.ISpriteAction action : this.actions) {
            int needed = action.getMinWidth(manager);
            if (!CustomSprite.isPowerOfTwo(needed)) {
                throw new IllegalArgumentException(needed + " was not a power of two!");
            }
            int p2 = MathHelper.func_151239_c((int)needed);
            if (p2 <= width) continue;
            width = p2;
        }
        int height = (int)Math.pow(2.0, width);
        BufferedImage image = new BufferedImage(height, height, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setClip(0, 0, height, height);
        graphics.setBackground(new Color(0, 0, 0, 0));
        graphics.clearRect(0, 0, height, height);
        for (SpriteBuilder.ISpriteAction action : this.actions) {
            action.apply(graphics, manager);
        }
        BufferedImage[] images = new BufferedImage[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1];
        images[0] = image;
        try {
            this.func_180598_a(images, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public void register(TextureMap map) {
        map.setTextureEntry(this.func_94215_i(), (TextureAtlasSprite)this);
    }
}

