/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.MathUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockMiner {
    protected final World world;
    protected final TileEntity owner;
    protected final BlockPos pos;
    private boolean hasMined;
    private boolean hasFailed;
    private int energyRequired;
    private int energyAccepted;

    public BlockMiner(World world, TileEntity owner, BlockPos pos) {
        this.world = world;
        this.owner = owner;
        this.pos = pos;
    }

    public boolean hasMined() {
        return this.hasMined;
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public void mineStack(ItemStack stack) {
        stack.field_77994_a -= Utils.addToRandomInventoryAround(this.owner.func_145831_w(), this.owner.func_174877_v(), stack);
        if (stack.field_77994_a > 0) {
            stack.field_77994_a -= Utils.addToRandomInjectableAround(this.owner.func_145831_w(), this.owner.func_174877_v(), null, stack);
        }
        if (stack.field_77994_a > 0) {
            float f = this.world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = this.world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = this.world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(this.owner.func_145831_w(), (double)((float)this.owner.func_174877_v().func_177958_n() + f), (double)((float)this.owner.func_174877_v().func_177956_o() + f1 + 0.5f), (double)((float)this.owner.func_174877_v().func_177952_p() + f2), stack);
            entityitem.lifespan = BuildCraftCore.itemLifespan * 20;
            entityitem.func_174869_p();
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)this.world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)this.world.field_73012_v.nextGaussian() * f3 + 1.0f;
            entityitem.field_70179_y = (float)this.world.field_73012_v.nextGaussian() * f3;
            this.owner.func_145831_w().func_72838_d((Entity)entityitem);
        }
    }

    public void invalidate() {
        this.world.func_175715_c(this.pos.hashCode(), this.pos, -1);
    }

    public int acceptEnergy(int offeredAmount) {
        if (BlockUtils.isUnbreakableBlock(this.world, this.pos)) {
            this.hasFailed = true;
            return 0;
        }
        this.energyRequired = BlockUtils.computeBlockBreakEnergy(this.world, this.pos);
        int usedAmount = MathUtils.clamp(offeredAmount, 0, Math.max(0, this.energyRequired - this.energyAccepted));
        this.energyAccepted += usedAmount;
        if (this.energyAccepted >= this.energyRequired) {
            this.world.func_175715_c(this.pos.hashCode(), this.pos, -1);
            IBlockState state = this.world.func_180495_p(this.pos);
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(this.world, this.pos, state, (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.world).get());
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (!breakEvent.isCanceled()) {
                List<ItemStack> stacks = BlockUtils.getItemStackFromBlock((WorldServer)this.world, this.pos);
                if (stacks != null) {
                    for (ItemStack s : stacks) {
                        if (s == null) continue;
                        this.mineStack(s);
                    }
                }
                this.world.func_180498_a(null, 2001, this.pos, Block.func_176210_f((IBlockState)state));
                this.world.func_175698_g(this.pos);
                this.hasMined = true;
            } else {
                this.hasFailed = true;
            }
        } else {
            this.world.func_175715_c(this.pos.hashCode(), this.pos, MathUtils.clamp((int)Math.floor(this.energyAccepted * 10 / this.energyRequired), 0, 9));
        }
        return usedAmount;
    }
}

