/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.core.Box;
import buildcraft.core.lib.utils.Utils;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;

public class Matrix4i {
    public static final Matrix4i IDENTITY = Matrix4i.makeScale((Vec3i)Utils.POS_ONE);
    private final int m00;
    private final int m01;
    private final int m02;
    private final int m03;
    private final int m10;
    private final int m11;
    private final int m12;
    private final int m13;
    private final int m20;
    private final int m21;
    private final int m22;
    private final int m23;
    private final int m30;
    private final int m31;
    private final int m32;
    private final int m33;

    public static Matrix4i makeTranslation(Vec3i vec) {
        return new Matrix4i(1, 0, 0, vec.func_177958_n(), 0, 1, 0, vec.func_177956_o(), 0, 0, 1, vec.func_177952_p(), 0, 0, 0, 1);
    }

    public static Matrix4i makeScale(Vec3i vec) {
        return new Matrix4i(vec.func_177958_n(), 0, 0, 0, 0, vec.func_177956_o(), 0, 0, 0, 0, vec.func_177952_p(), 0, 0, 0, 0, 1);
    }

    public static Matrix4i makeRotY(int ang) {
        if (ang % 90 != 0) {
            throw new IllegalArgumentException("You can only have angles in increments of 90 degrees!");
        }
        if ((ang %= 360) == 90) {
            return new Matrix4i(0, 0, 1, 0, 0, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 1);
        }
        if (ang == 180) {
            return new Matrix4i(-1, 0, 0, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1);
        }
        if (ang == 270) {
            return new Matrix4i(0, 0, -1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1);
        }
        return IDENTITY;
    }

    public static Matrix4i makeRotLeftTranslatePositive(Box box) {
        BlockPos translation = box.min();
        Matrix4i translateBack = Matrix4i.makeTranslation((Vec3i)Utils.invert(translation));
        Matrix4i rotY = Matrix4i.makeRotY(270);
        Matrix4i translateForth = Matrix4i.makeTranslation((Vec3i)translation.func_177971_a(new Vec3i(box.size().func_177952_p() - 1, 0, 0)));
        Matrix4i total = translateForth.multiply(rotY).multiply(translateBack);
        return total;
    }

    public static Matrix4i multiply(Matrix4i m1, Matrix4i m2) {
        int m00 = m1.m00 * m2.m00 + m1.m01 * m2.m10 + m1.m02 * m2.m20 + m1.m03 * m2.m30;
        int m01 = m1.m00 * m2.m01 + m1.m01 * m2.m11 + m1.m02 * m2.m21 + m1.m03 * m2.m31;
        int m02 = m1.m00 * m2.m02 + m1.m01 * m2.m12 + m1.m02 * m2.m22 + m1.m03 * m2.m32;
        int m03 = m1.m00 * m2.m03 + m1.m01 * m2.m13 + m1.m02 * m2.m23 + m1.m03 * m2.m33;
        int m10 = m1.m10 * m2.m00 + m1.m11 * m2.m10 + m1.m12 * m2.m20 + m1.m13 * m2.m30;
        int m11 = m1.m10 * m2.m01 + m1.m11 * m2.m11 + m1.m12 * m2.m21 + m1.m13 * m2.m31;
        int m12 = m1.m10 * m2.m02 + m1.m11 * m2.m12 + m1.m12 * m2.m22 + m1.m13 * m2.m32;
        int m13 = m1.m10 * m2.m03 + m1.m11 * m2.m13 + m1.m12 * m2.m23 + m1.m13 * m2.m33;
        int m20 = m1.m20 * m2.m00 + m1.m21 * m2.m10 + m1.m22 * m2.m20 + m1.m23 * m2.m30;
        int m21 = m1.m20 * m2.m01 + m1.m21 * m2.m11 + m1.m22 * m2.m21 + m1.m23 * m2.m31;
        int m22 = m1.m20 * m2.m02 + m1.m21 * m2.m12 + m1.m22 * m2.m22 + m1.m23 * m2.m32;
        int m23 = m1.m20 * m2.m03 + m1.m21 * m2.m13 + m1.m22 * m2.m23 + m1.m23 * m2.m33;
        int m30 = m1.m30 * m2.m00 + m1.m31 * m2.m10 + m1.m32 * m2.m20 + m1.m33 * m2.m30;
        int m31 = m1.m30 * m2.m01 + m1.m31 * m2.m11 + m1.m32 * m2.m21 + m1.m33 * m2.m31;
        int m32 = m1.m30 * m2.m02 + m1.m31 * m2.m12 + m1.m32 * m2.m22 + m1.m33 * m2.m32;
        int m33 = m1.m30 * m2.m03 + m1.m31 * m2.m13 + m1.m32 * m2.m23 + m1.m33 * m2.m33;
        return new Matrix4i(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
    }

    public Matrix4i(int i00, int i01, int i02, int i03, int i10, int i11, int i12, int i13, int i20, int i21, int i22, int i23, int i30, int i31, int i32, int i33) {
        this.m00 = i00;
        this.m01 = i01;
        this.m02 = i02;
        this.m03 = i03;
        this.m10 = i10;
        this.m11 = i11;
        this.m12 = i12;
        this.m13 = i13;
        this.m20 = i20;
        this.m21 = i21;
        this.m22 = i22;
        this.m23 = i23;
        this.m30 = i30;
        this.m31 = i31;
        this.m32 = i32;
        this.m33 = i33;
    }

    public Matrix4i multiply(Matrix4i m1) {
        return Matrix4i.multiply(this, m1);
    }

    public BlockPos multiplyPosition(Vec3i pos) {
        int x = pos.func_177958_n() * this.m00 + pos.func_177956_o() * this.m01 + pos.func_177952_p() * this.m02 + this.m03;
        int y = pos.func_177958_n() * this.m10 + pos.func_177956_o() * this.m11 + pos.func_177952_p() * this.m12 + this.m13;
        int z = pos.func_177958_n() * this.m20 + pos.func_177956_o() * this.m21 + pos.func_177952_p() * this.m22 + this.m23;
        BlockPos end = new BlockPos(x, y, z);
        return end;
    }

    public Matrix4i addTranslation(Vec3i trans) {
        return this.multiply(Matrix4i.makeTranslation(trans));
    }

    public Matrix4i addScale(Vec3i scale) {
        return this.multiply(Matrix4i.makeScale(scale));
    }

    public String toString() {
        return this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + "\n" + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + "\n" + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + "\n" + this.m30 + ", " + this.m31 + ", " + this.m32 + ", " + this.m33;
    }
}

