/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.world;

import buildcraft.core.lib.render.RenderUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.lib.world.FakeWorld;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.Vec3i;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public class FakeWorldManager {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final BlockPos min;
    private final BlockPos max;
    private final FakeWorld world;
    private final EnumMap<EnumWorldBlockLayer, Tessellator> tessMap = Maps.newEnumMap(EnumWorldBlockLayer.class);
    private final EnumMap<EnumWorldBlockLayer, Integer> displayListMap = Maps.newEnumMap(EnumWorldBlockLayer.class);

    public FakeWorldManager(FakeWorld world) {
        this.world = world;
        for (EnumWorldBlockLayer layer : EnumWorldBlockLayer.values()) {
            this.tessMap.put(layer, new Tessellator(65536));
        }
        world.func_72835_b();
        this.min = new BlockPos(-64, 0, -64);
        this.max = new BlockPos(64, 8, 64);
    }

    public void deleteAll() {
        for (int list : this.displayListMap.values()) {
            GL11.glDeleteLists((int)list, (int)1);
        }
        this.displayListMap.clear();
    }

    public void renderWorld(double mouseX, double mouseY, double sf, BlockPos offset) {
        this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(2000.0 - sf));
        GL11.glMatrixMode((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        float aspect = (float)this.mc.field_71443_c / (float)this.mc.field_71440_d;
        Project.gluPerspective((float)this.mc.field_71474_y.field_74334_X, (float)aspect, (float)0.01f, (float)(this.mc.field_71474_y.field_151451_c * 1000));
        GL11.glMatrixMode((int)5888);
        GL11.glRotated((double)mouseY, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)mouseX, (double)0.0, (double)1.0, (double)0.0);
        RenderUtils.translate(Utils.multiply(Utils.convert((Vec3i)offset), -0.5));
        this.renderAll();
        GL11.glMatrixMode((int)5889);
        GlStateManager.func_179121_F();
        GL11.glMatrixMode((int)5888);
        GlStateManager.func_179121_F();
    }

    private void renderAll() {
        GlStateManager.func_179118_c();
        EnumWorldBlockLayer layer = EnumWorldBlockLayer.SOLID;
        this.renderAllChunks(layer);
        layer = EnumWorldBlockLayer.CUTOUT_MIPPED;
        GlStateManager.func_179141_d();
        this.renderAllChunks(layer);
        layer = EnumWorldBlockLayer.CUTOUT;
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        this.renderAllChunks(layer);
        this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        layer = EnumWorldBlockLayer.TRANSLUCENT;
        if (this.mc.field_71474_y.field_74347_j) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            this.renderAllChunks(layer);
            GlStateManager.func_179084_k();
        } else {
            this.renderAllChunks(layer);
        }
    }

    private void renderAllChunks(EnumWorldBlockLayer layer) {
        Tessellator tess = this.tessMap.get(layer);
        WorldRenderer renderer = tess.func_178180_c();
        if (this.displayListMap.containsKey(layer)) {
            GL11.glCallList((int)this.displayListMap.get(layer));
        } else if (this.world.hasDeployed) {
            int list = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)list, (int)4864);
            renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            this.renderAllBlocks(layer, renderer);
            tess.func_78381_a();
            GL11.glEndList();
            this.displayListMap.put(layer, list);
        }
    }

    private void renderAllBlocks(EnumWorldBlockLayer layer, WorldRenderer renderer) {
        for (ChunkCoordIntPair ccip : Utils.allChunksFor(this.min, this.max)) {
            if (!this.world.func_72863_F().func_73149_a(ccip.field_77276_a, ccip.field_77275_b)) continue;
            Chunk chunk = this.world.func_72964_e(ccip.field_77276_a, ccip.field_77275_b);
            boolean hasObj = false;
            for (int h : chunk.func_177445_q()) {
                if (h <= 1) continue;
                hasObj = true;
                break;
            }
            if (!hasObj) continue;
            Object object = Utils.allInChunk(ccip).iterator();
            while (object.hasNext()) {
                BlockPos pos = (BlockPos)object.next();
                this.renderBlock(pos, layer, renderer);
            }
        }
    }

    private void renderBlock(BlockPos pos, EnumWorldBlockLayer layer, WorldRenderer renderer) {
        IBlockState actualState = this.world.func_180495_p(pos);
        Block block = actualState.func_177230_c();
        if (block == Blocks.field_150350_a || block == null) {
            return;
        }
        if (!block.canRenderInLayer(layer)) {
            return;
        }
        actualState = block.func_176221_a(actualState, (IBlockAccess)this.world, pos);
        BlockRendererDispatcher dispatcher = this.mc.func_175602_ab();
        IBakedModel model = dispatcher.func_175023_a().func_178125_b(actualState);
        if (model == null) {
            return;
        }
        boolean checkSides = pos.func_177956_o() > 0;
        try {
            dispatcher.func_175019_b().func_178258_b((IBlockAccess)this.world, model, block, pos, renderer, checkSides);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("The model from the block " + block + " was invalid for layer " + layer, t);
        }
    }
}

