/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.properties;

import buildcraft.core.properties.ChunkProperty;
import buildcraft.core.properties.WorldProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class DimensionProperty
implements IWorldAccess {
    private final LongHashMap chunkMapping = new LongHashMap();
    private final World world;
    private final int worldHeight;
    private final WorldProperty worldProperty;

    public DimensionProperty(World iWorld, WorldProperty iProp) {
        this.world = iWorld;
        this.worldHeight = iWorld.func_72940_L();
        this.world.func_72954_a((IWorldAccess)this);
        this.worldProperty = iProp;
    }

    public synchronized boolean get(BlockPos pos) {
        int xChunk = pos.func_177958_n() >> 4;
        int zChunk = pos.func_177952_p() >> 4;
        if (this.world.func_72863_F().func_73149_a(xChunk, zChunk)) {
            ChunkProperty property;
            long chunkId = ChunkCoordIntPair.func_77272_a((int)xChunk, (int)zChunk);
            if (!this.chunkMapping.func_76161_b(chunkId)) {
                property = new ChunkProperty((IBlockAccess)this.world, this.world.func_72800_K(), xChunk, zChunk);
                this.chunkMapping.func_76163_a(chunkId, (Object)property);
                this.load(this.world.func_72964_e(xChunk, zChunk), property);
            } else {
                property = (ChunkProperty)this.chunkMapping.func_76164_a(chunkId);
            }
            return property.get(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Chunk chunk, ChunkProperty property) {
        World world = this.world;
        synchronized (world) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < this.worldHeight; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        BlockPos pos = new BlockPos(chunk.field_76635_g * 16 + x, y, chunk.field_76647_h * 16 + z);
                        IBlockState state = chunk.func_177435_g(pos);
                        boolean prop = this.worldProperty.get((IBlockAccess)this.world, state, pos);
                        property.set(x, y, z, prop);
                    }
                }
            }
        }
    }

    public synchronized void func_174960_a(BlockPos pos) {
        long chunkId;
        int xChunk = pos.func_177958_n() >> 4;
        int zChunk = pos.func_177952_p() >> 4;
        if (this.world.func_72863_F().func_73149_a(xChunk, zChunk) && this.chunkMapping.func_76161_b(chunkId = ChunkCoordIntPair.func_77272_a((int)xChunk, (int)zChunk))) {
            ChunkProperty property = (ChunkProperty)this.chunkMapping.func_76164_a(chunkId);
            IBlockState state = this.world.func_180495_p(pos);
            boolean prop = this.worldProperty.get((IBlockAccess)this.world, state, pos);
            property.set(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF, prop);
        }
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_72704_a(String var1, double var2, double var4, double var6, float var8, float var9) {
    }

    public void func_85102_a(EntityPlayer var1, String var2, double var3, double var5, double var7, float var9, float var10) {
    }

    public void clear() {
        this.world.func_72848_b((IWorldAccess)this);
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean p_180442_2_, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset, int ... p_180442_15_) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_174961_a(String recordName, BlockPos blockPosIn) {
    }

    public void func_180440_a(int p_180440_1_, BlockPos p_180440_2_, int p_180440_3_) {
    }

    public void func_180439_a(EntityPlayer player, int sfxType, BlockPos blockPosIn, int p_180439_4_) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }
}

