/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.api.core.BCLog;
import buildcraft.core.StackAtPosition;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.IBuildingItemsProvider;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class RenderBuildingItems {
    private final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(TileEntity tile, double x, double y, double z) {
        IBuildingItemsProvider provider = (IBuildingItemsProvider)tile;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)(-tile.func_174877_v().func_177958_n()), (double)(-tile.func_174877_v().func_177956_o()), (double)(-tile.func_174877_v().func_177952_p()));
        if (provider.getBuilders() != null) {
            Collection<BuildingItem> collection = provider.getBuilders();
            synchronized (collection) {
                for (BuildingItem i : provider.getBuilders()) {
                    this.doRenderItem(i, 1.0f);
                }
            }
        }
        GL11.glPopMatrix();
    }

    private void doRenderItem(BuildingItem i, float light) {
        if (i == null) {
            return;
        }
        i.displayUpdate();
        for (StackAtPosition s : i.getStacks()) {
            if (!s.display) continue;
            if (s.stack != null) {
                IBakedModel model = this.renderItem.func_175037_a().func_178089_a(s.stack);
                if (model != null) {
                    float renderScale = 0.7f;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)s.pos.field_72450_a), (float)((float)s.pos.field_72448_b), (float)((float)s.pos.field_72449_c));
                    GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
                    GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
                    this.renderItem.func_180454_a(s.stack, model);
                    GL11.glPopMatrix();
                    continue;
                }
                BCLog.logger.warn("Model was null for " + s.stack);
                continue;
            }
            BCLog.logger.warn("ItemStack was null for " + s + ", " + i);
        }
    }
}

