/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.core.EntityLaser;
import buildcraft.core.LaserData;
import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.render.RenderResizableCuboid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderLaser
extends Render<EntityLaser> {
    public static final float STEP = 0.04f;
    protected static ModelBase model = new ModelBase(){};
    private static ModelRenderer[] box;
    private static int[][] scaledBoxes;

    public RenderLaser() {
        super(Minecraft.func_71410_x().func_175598_ae());
    }

    public static void onTextureReload() {
        scaledBoxes = null;
    }

    private static ModelRenderer getBox(int index) {
        if (box == null) {
            box = new ModelRenderer[40];
            for (int j = 0; j < box.length; ++j) {
                RenderLaser.box[j] = new ModelRenderer(model, box.length - j, 0);
                box[j].func_78789_a(0.0f, -0.5f, -0.5f, 16, 1, 1);
                RenderLaser.box[j].field_78800_c = 0.0f;
                RenderLaser.box[j].field_78797_d = 0.0f;
                RenderLaser.box[j].field_78798_e = 0.0f;
            }
        }
        return box[index];
    }

    private static void initScaledBoxes(World world) {
        if (scaledBoxes == null) {
            scaledBoxes = new int[100][20];
            for (int size = 0; size < 100; ++size) {
                for (int i = 0; i < 20; ++i) {
                    RenderLaser.scaledBoxes[size][i] = GLAllocation.func_74526_a((int)1);
                    GL11.glNewList((int)scaledBoxes[size][i], (int)4864);
                    EntityResizableCuboid cuboid = new EntityResizableCuboid(null);
                    float minSize = 0.2f * (float)size / 100.0f;
                    float maxSize = 0.4f * (float)size / 100.0f;
                    float range = maxSize - minSize;
                    float diff = (float)(Math.cos((double)((float)i / 20.0f * 2.0f) * Math.PI) * (double)range / 2.0);
                    cuboid.setPosition(new Vec3(0.0, (double)(-maxSize / 2.0f - diff), (double)(-maxSize / 2.0f - diff)));
                    cuboid.setSize(new Vec3((double)0.04f, (double)(maxSize / 2.0f - diff), (double)(maxSize / 2.0f - diff)));
                    RenderResizableCuboid.INSTANCE.renderCube(cuboid);
                    GL11.glEndList();
                }
            }
        }
    }

    public void doRender(EntityLaser laser, double x, double y, double z, float f, float f1) {
        if (!laser.isVisible() || laser.getTexture() == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        Vec3 offset = laser.renderOffset();
        GL11.glTranslated((double)offset.field_72450_a, (double)offset.field_72448_b, (double)offset.field_72449_c);
        GL11.glTranslated((double)(x - laser.data.head.field_72450_a), (double)(y - laser.data.head.field_72448_b), (double)(z - laser.data.head.field_72449_c));
        RenderLaser.doRenderLaser(laser.field_70170_p, this.field_76990_c.field_78724_e, laser.data, laser.getTexture());
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void doRenderLaserWave(World world, TextureManager textureManager, LaserData laser, ResourceLocation texture) {
        if (!laser.isVisible || texture == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)laser.head.field_72450_a, (double)laser.head.field_72448_b, (double)laser.head.field_72449_c);
        laser.update();
        GL11.glRotatef((float)((float)laser.angleZ), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)laser.angleY), (float)0.0f, (float)0.0f, (float)1.0f);
        textureManager.func_110577_a(texture);
        int indexList = 0;
        RenderLaser.initScaledBoxes(world);
        double x1 = laser.wavePosition;
        double x2 = x1 + (double)((float)scaledBoxes[0].length * 0.04f);
        double x3 = laser.renderSize;
        RenderLaser.doRenderLaserLine(x1, laser.laserTexAnimation);
        for (double i = x1; i <= x2 && i <= laser.renderSize; i += (double)0.04f) {
            GL11.glCallList((int)scaledBoxes[(int)(laser.waveSize * 99.0f)][indexList]);
            indexList = (indexList + 1) % scaledBoxes[0].length;
            GL11.glTranslated((double)0.04f, (double)0.0, (double)0.0);
        }
        if (x2 < x3) {
            RenderLaser.doRenderLaserLine(x3 - x2, laser.laserTexAnimation);
        }
        GL11.glPopMatrix();
    }

    public static void doRenderLaser(World world, TextureManager textureManager, LaserData laser, ResourceLocation texture) {
        if (!laser.isVisible || texture == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)laser.head.field_72450_a, (double)laser.head.field_72448_b, (double)laser.head.field_72449_c);
        laser.update();
        GL11.glRotatef((float)((float)laser.angleZ), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)laser.angleY), (float)0.0f, (float)0.0f, (float)1.0f);
        textureManager.func_110577_a(texture);
        RenderLaser.initScaledBoxes(world);
        RenderLaser.doRenderLaserLine(laser.renderSize, laser.laserTexAnimation);
        GL11.glPopMatrix();
        GL11.glLineWidth((float)2.0f);
        GL11.glBegin((int)1);
        GL11.glTexCoord2d((double)0.9999, (double)0.9999);
        GL11.glVertex3d((double)laser.head.field_72450_a, (double)laser.head.field_72448_b, (double)laser.head.field_72449_c);
        GL11.glVertex3d((double)laser.tail.field_72450_a, (double)laser.tail.field_72448_b, (double)laser.tail.field_72449_c);
        GL11.glEnd();
    }

    private static void doRenderLaserLine(double len, int texId) {
        float lasti = 0.0f;
        if (len - 1.0 > 0.0) {
            float i = 0.0f;
            while ((double)i <= len - 1.0) {
                RenderLaser.getBox(texId).func_78785_a(0.0625f);
                GL11.glTranslated((double)1.0, (double)0.0, (double)0.0);
                lasti = i;
                i += 1.0f;
            }
            lasti += 1.0f;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)((float)len - lasti), (float)1.0f, (float)1.0f);
        RenderLaser.getBox(texId).func_78785_a(0.0625f);
        GL11.glPopMatrix();
        GL11.glTranslated((double)((float)(len - (double)lasti)), (double)0.0, (double)0.0);
    }

    protected ResourceLocation getEntityTexture(EntityLaser entity) {
        return entity.getTexture();
    }
}

