/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TriggerEnergy
extends BCStatement
implements ITriggerInternal {
    private final boolean high;

    public TriggerEnergy(boolean high) {
        super("buildcraft:energyStored" + (high ? "high" : "low"));
        this.setBuildCraftLocation("core", "triggers/trigger_energy_storage_" + (high ? "high" : "low"));
        this.high = high;
    }

    @Override
    public String getDescription() {
        return BCStringUtils.localize("gate.trigger.machine.energyStored." + (this.high ? "high" : "low"));
    }

    private boolean isTriggeredEnergyHandler(IEnergyConnection connection, EnumPipePart part) {
        int energyMaxStored;
        int energyStored;
        EnumFacing side = part.face;
        if (connection instanceof IEnergyHandler) {
            energyStored = ((IEnergyHandler)connection).getEnergyStored(side);
            energyMaxStored = ((IEnergyHandler)connection).getMaxEnergyStored(side);
        } else if (connection instanceof IEnergyProvider) {
            energyStored = ((IEnergyProvider)connection).getEnergyStored(side);
            energyMaxStored = ((IEnergyProvider)connection).getMaxEnergyStored(side);
        } else if (connection instanceof IEnergyReceiver) {
            energyStored = ((IEnergyReceiver)connection).getEnergyStored(side);
            energyMaxStored = ((IEnergyReceiver)connection).getMaxEnergyStored(side);
        } else {
            return false;
        }
        if (energyMaxStored > 0) {
            float level = (float)energyStored / (float)energyMaxStored;
            if (this.high) {
                return level > 0.95f;
            }
            return level < 0.05f;
        }
        return false;
    }

    protected static boolean isTriggered(Object tile, EnumPipePart side) {
        if (tile instanceof IEnergyConnection) {
            return ((IEnergyConnection)tile).canConnectEnergy(side.opposite().face);
        }
        return false;
    }

    protected boolean isActive(Object tile, EnumPipePart side) {
        if (TriggerEnergy.isTriggered(tile, side)) {
            return this.isTriggeredEnergyHandler((IEnergyConnection)tile, side.opposite());
        }
        return false;
    }

    public static boolean isTriggeringPipe(TileEntity tile) {
        IPipeTile pipeTile;
        return tile instanceof IPipeTile && (pipeTile = (IPipeTile)tile).getPipeType() == IPipeTile.PipeType.POWER && pipeTile.getPipe() instanceof IEnergyHandler;
    }

    @Override
    public boolean isTriggerActive(IStatementContainer source, IStatementParameter[] parameters) {
        if (TriggerEnergy.isTriggeringPipe(source.getTile())) {
            return this.isActive(((IPipeTile)source.getTile()).getPipe(), null);
        }
        Neighbor triggeringNeighbor = TriggerEnergy.getTriggeringNeighbor(source.getTile());
        if (triggeringNeighbor != null) {
            return this.isActive(triggeringNeighbor.tile, triggeringNeighbor.side);
        }
        return false;
    }

    public static Neighbor getTriggeringNeighbor(TileEntity parent) {
        if (parent instanceof IPipeTile) {
            for (EnumPipePart side : EnumPipePart.validFaces()) {
                TileEntity tile = ((IPipeTile)parent).getNeighborTile(side.face);
                if (tile == null || !TriggerEnergy.isTriggered(tile, side)) continue;
                return new Neighbor(tile, side);
            }
        } else {
            for (EnumPipePart side : EnumPipePart.validFaces()) {
                TileEntity tile = parent.func_145831_w().func_175625_s(parent.func_174877_v().func_177972_a(side.face));
                if (tile == null || !TriggerEnergy.isTriggered(tile, side)) continue;
                return new Neighbor(tile, side);
            }
        }
        return null;
    }

    public static class Neighbor {
        public TileEntity tile;
        public EnumPipePart side;

        public Neighbor(TileEntity tile, EnumPipePart side) {
            this.tile = tile;
            this.side = side;
        }
    }
}

