/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.ItemList;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import java.util.Locale;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TriggerInventory
extends BCStatement
implements ITriggerExternal {
    public State state;

    public TriggerInventory(State state) {
        super("buildcraft:inventory." + state.name().toLowerCase(Locale.ENGLISH), "buildcraft.inventory." + state.name().toLowerCase(Locale.ENGLISH));
        this.setBuildCraftLocation("core", "triggers/trigger_inventory_" + state.name().toLowerCase(Locale.ROOT));
        this.state = state;
    }

    @Override
    public int maxParameters() {
        return this.state == State.Contains || this.state == State.Space ? 1 : 0;
    }

    @Override
    public String getDescription() {
        return BCStringUtils.localize("gate.trigger.inventory." + this.state.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer container, IStatementParameter[] parameters) {
        ItemStack searchedStack = null;
        if (parameters != null && parameters.length >= 1 && parameters[0] != null) {
            searchedStack = parameters[0].getItemStack();
        }
        if (tile instanceof IInventory) {
            boolean hasSlots = false;
            boolean foundItems = false;
            boolean foundSpace = false;
            for (IInvSlot slot : InventoryIterator.getIterable((IInventory)tile, side.func_176734_d())) {
                hasSlots = true;
                ItemStack stack = slot.getStackInSlot();
                foundItems |= stack != null && (searchedStack == null || StackHelper.canStacksOrListsMerge(stack, searchedStack));
                foundSpace |= (stack == null || StackHelper.canStacksOrListsMerge(stack, searchedStack) && stack.field_77994_a < stack.func_77976_d()) && (searchedStack == null || searchedStack.func_77973_b() instanceof ItemList || slot.canPutStackInSlot(searchedStack));
            }
            if (!hasSlots) {
                return false;
            }
            switch (this.state) {
                case Empty: {
                    return !foundItems;
                }
                case Contains: {
                    return foundItems;
                }
                case Space: {
                    return foundSpace;
                }
            }
            return !foundSpace;
        }
        return false;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

