/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TriggerMachine
extends BCStatement
implements ITriggerExternal {
    boolean active;

    public TriggerMachine(boolean active) {
        super("buildcraft:work." + (active ? "scheduled" : "done"), "buildcraft.work." + (active ? "scheduled" : "done"));
        this.setBuildCraftLocation("core", "triggers/trigger_machine_" + (active ? "active" : "inactive"));
        this.active = active;
    }

    @Override
    public String getDescription() {
        return BCStringUtils.localize("gate.trigger.machine." + (this.active ? "scheduled" : "done"));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer container, IStatementParameter[] parameters) {
        if (tile instanceof IHasWork) {
            IHasWork machine = (IHasWork)tile;
            if (this.active) {
                return machine.hasWork();
            }
            return !machine.hasWork();
        }
        return false;
    }
}

