/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.containers.IRedstoneStatementContainer;
import buildcraft.api.statements.containers.ISidedStatementContainer;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.statements.StatementParameterRedstoneGateSideOnly;

public class TriggerRedstoneInput
extends BCStatement
implements ITriggerInternal {
    boolean active;

    public TriggerRedstoneInput(boolean active) {
        super("buildcraft:redstone.input." + (active ? "active" : "inactive"), active ? "buildcraft.redtone.input.active" : "buildcraft.redtone.input.inactive");
        this.setBuildCraftLocation("core", "triggers/trigger_redstoneinput_" + (active ? "active" : "inactive"));
        this.active = active;
    }

    @Override
    public String getDescription() {
        return BCStringUtils.localize("gate.trigger.redstone.input." + (this.active ? "active" : "inactive"));
    }

    @Override
    public IStatementParameter createParameter(int index) {
        StatementParameterRedstoneGateSideOnly param = null;
        if (index == 0) {
            param = new StatementParameterRedstoneGateSideOnly();
        }
        return param;
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        if (container instanceof IRedstoneStatementContainer) {
            int level = ((IRedstoneStatementContainer)((Object)container)).getRedstoneInput(null);
            if (parameters.length > 0 && parameters[0] instanceof StatementParameterRedstoneGateSideOnly && ((StatementParameterRedstoneGateSideOnly)parameters[0]).isOn && container instanceof ISidedStatementContainer) {
                level = ((IRedstoneStatementContainer)((Object)container)).getRedstoneInput(((ISidedStatementContainer)container).getSide());
            }
            return this.active ? level > 0 : level == 0;
        }
        return false;
    }
}

