/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.client.CoreIconProvider;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.utils.BCStringUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public abstract class GuiEngine
extends GuiBuildCraft {
    private static final ResourceLocation TEXTURES = TextureMap.field_110575_b;

    public GuiEngine(BuildCraftContainer container, IInventory inventory, ResourceLocation texture) {
        super(container, inventory, texture);
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        if (!BuildCraftCore.hidePowerNumbers) {
            this.ledgerManager.add(new EngineLedger((TileEngineBase)this.tile));
        }
    }

    protected class EngineLedger
    extends GuiBuildCraft.Ledger {
        TileEngineBase engine;
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public EngineLedger(TileEngineBase engine) {
            this.engine = engine;
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURES);
            this.drawIcon(CoreIconProvider.ENERGY.getSprite(), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiEngine.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.energy"), (float)(x + 22), (float)(y + 8), this.headerColour);
            GuiEngine.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.currentOutput") + ":", (float)(x + 22), (float)(y + 20), this.subheaderColour);
            GuiEngine.this.field_146289_q.func_78276_b(String.format("%d RF/t", this.engine.currentOutput), x + 22, y + 32, this.textColour);
            GuiEngine.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.stored") + ":", (float)(x + 22), (float)(y + 44), this.subheaderColour);
            GuiEngine.this.field_146289_q.func_78276_b(String.format("%d RF", this.engine.getEnergyStored()), x + 22, y + 56, this.textColour);
            GuiEngine.this.field_146289_q.func_175063_a(BCStringUtils.localize("gui.heat") + ":", (float)(x + 22), (float)(y + 68), this.subheaderColour);
            GuiEngine.this.field_146289_q.func_78276_b(String.format("%.2f \u00b0C", this.engine.getCurrentHeatValue()), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%d RF/t", this.engine.currentOutput);
        }
    }
}

