/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.transport.ICustomPipeConnection;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.factory.TileTank;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTank
extends BlockBuildCraft
implements ICustomPipeConnection {
    private static final boolean DEBUG_MODE = false;

    public BlockTank() {
        super(Material.field_151592_s, JOINED_BELOW);
        this.func_149711_c(0.5f);
        this.func_149647_a(BCCreativeTab.get("main"));
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileTank) {
            TileTank tank = (TileTank)tile;
            tank.onBlockBreak();
        }
        TileEntity tileAbove = world.func_175625_s(pos.func_177984_a());
        TileEntity tileBelow = world.func_175625_s(pos.func_177977_b());
        super.func_180663_b(world, pos, state);
        if (tileAbove instanceof TileTank) {
            ((TileTank)tileAbove).updateComparators();
            world.func_175656_a(pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()).func_177226_a((IProperty)JOINED_BELOW, (Comparable)Boolean.valueOf(false)));
        }
        if (tileBelow instanceof TileTank) {
            ((TileTank)tileBelow).updateComparators();
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
        IBlockState stateBelow = world.func_180495_p(pos.func_177977_b());
        if (stateAbove.func_177230_c() == this) {
            world.func_175656_a(pos.func_177984_a(), stateAbove.func_177226_a((IProperty)JOINED_BELOW, (Comparable)Boolean.valueOf(true)));
        }
        if (stateBelow.func_177230_c() == this) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)JOINED_BELOW, (Comparable)Boolean.valueOf(true)));
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileTank();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing side, float par7, float par8, float par9) {
        TileEntity tile;
        if (super.func_180639_a(world, pos, state, entityplayer, side, par7, par8, par9)) {
            return true;
        }
        ItemStack current = entityplayer.field_71071_by.func_70448_g();
        if (current != null && (tile = world.func_175625_s(pos)) instanceof TileTank) {
            TileTank tank = (TileTank)tile;
            if (FluidContainerRegistry.isContainer((ItemStack)current)) {
                ItemStack filled;
                FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
                if (liquid != null) {
                    int qty = tank.fill(null, liquid, true);
                    if (qty != 0 && !BuildCraftCore.debugWorldgen && !entityplayer.field_71075_bZ.field_75098_d) {
                        if (current.field_77994_a > 1) {
                            if (!entityplayer.field_71071_by.func_70441_a(FluidContainerRegistry.drainFluidContainer((ItemStack)current))) {
                                entityplayer.func_71019_a(FluidContainerRegistry.drainFluidContainer((ItemStack)current), false);
                            }
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, InvUtils.consumeItem(current));
                        } else {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, FluidContainerRegistry.drainFluidContainer((ItemStack)current));
                        }
                    }
                    return true;
                }
                FluidStack available = tank.getTankInfo(null)[0].fluid;
                if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                    if (!BuildCraftCore.debugWorldgen && !entityplayer.field_71075_bZ.field_75098_d) {
                        if (current.field_77994_a > 1) {
                            if (!entityplayer.field_71071_by.func_70441_a(filled)) {
                                return false;
                            }
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, InvUtils.consumeItem(current));
                        } else {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, InvUtils.consumeItem(current));
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, filled);
                        }
                    }
                    tank.drain(null, liquid.amount, true);
                    return true;
                }
            } else if (current.func_77973_b() instanceof IFluidContainerItem) {
                if (current.field_77994_a != 1) {
                    return false;
                }
                if (!world.field_72995_K) {
                    boolean mustFill;
                    IFluidContainerItem container = (IFluidContainerItem)current.func_77973_b();
                    FluidStack liquid = container.getFluid(current);
                    FluidStack tankLiquid = tank.getTankInfo(null)[0].fluid;
                    boolean mustDrain = liquid == null || liquid.amount == 0;
                    boolean bl = mustFill = tankLiquid == null || tankLiquid.amount == 0;
                    if (!mustDrain || !mustFill) {
                        if (mustDrain || !entityplayer.func_70093_af()) {
                            liquid = tank.drain(null, 1000, false);
                            int qtyToFill = container.fill(current, liquid, true);
                            tank.drain(null, qtyToFill, true);
                        } else if ((mustFill || entityplayer.func_70093_af()) && liquid != null && liquid.amount > 0) {
                            int qty = tank.fill(null, liquid, false);
                            tank.fill(null, container.drain(current, qty, true), true);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_176225_a(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return world.func_180495_p(pos).func_177230_c() != this;
        }
        return super.func_176225_a(world, pos, side);
    }

    @Override
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTank) {
            TileTank tank = (TileTank)tile;
            return tank.getFluidLightLevel();
        }
        return super.getLightValue(world, pos);
    }

    @Override
    public boolean func_149740_M() {
        return true;
    }

    @Override
    public int func_180641_l(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTank) {
            TileTank tank = (TileTank)tile;
            return tank.getComparatorInputOverride();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    @Override
    public AxisAlignedBB getBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        return new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    }

    @Override
    public float getExtension(World world, BlockPos pos, EnumFacing face, IBlockState state) {
        return face.func_176740_k() != EnumFacing.Axis.Y ? 0.125f : 0.0f;
    }
}

