/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.fluids.TankUtils;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.Utils;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFloodGate
extends TileBuildCraft
implements IFluidHandler {
    public static final int[] REBUILD_DELAY = new int[8];
    public static final int MAX_LIQUID = 2000;
    private final TreeMap<Integer, Deque<BlockPos>> pumpLayerQueues = new TreeMap();
    private final Set<BlockPos> visitedBlocks = new HashSet<BlockPos>();
    private Deque<BlockPos> fluidsFound = new LinkedList<BlockPos>();
    private final Tank tank = new Tank("tank", 2000, this);
    private int rebuildDelay;
    private int tick = Utils.RANDOM.nextInt();
    private boolean powered = false;
    private EnumMap<EnumFacing, Boolean> blockedSides = Maps.newEnumMap(EnumFacing.class);

    @Override
    public void func_73660_a() {
        FluidStack fluidtoFill;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.powered) {
            return;
        }
        ++this.tick;
        if (this.tick % 16 == 0 && (fluidtoFill = this.tank.drain(1000, false)) != null && fluidtoFill.amount == 1000) {
            BlockPos index;
            Fluid fluid = fluidtoFill.getFluid();
            if (fluid == null || !fluid.canBePlacedInWorld()) {
                return;
            }
            if (fluid == FluidRegistry.WATER && this.field_145850_b.field_73011_w.func_177502_q() == -1) {
                this.tank.drain(1000, true);
                return;
            }
            if (this.tick % REBUILD_DELAY[this.rebuildDelay] == 0) {
                ++this.rebuildDelay;
                if (this.rebuildDelay >= REBUILD_DELAY.length) {
                    this.rebuildDelay = REBUILD_DELAY.length - 1;
                }
                this.rebuildQueue();
            }
            if ((index = this.getNextIndexToFill(true)) != null && this.placeFluid(index, fluid)) {
                this.tank.drain(1000, true);
                this.rebuildDelay = 0;
            }
        }
    }

    private boolean placeFluid(BlockPos pos, Fluid fluid) {
        Block block = BlockUtils.getBlockState(this.field_145850_b, pos).func_177230_c();
        if (this.canPlaceFluidAt(block, pos)) {
            boolean placed;
            Block b = TankUtils.getFluidBlock(fluid, true);
            if (b instanceof BlockFluidBase) {
                BlockFluidBase blockFluid = (BlockFluidBase)b;
                placed = this.field_145850_b.func_180501_a(pos, blockFluid.func_176223_P(), 3);
            } else {
                placed = this.field_145850_b.func_175656_a(pos, b.func_176223_P());
            }
            if (placed) {
                this.queueAdjacent(pos);
                this.expandQueue();
            }
            return placed;
        }
        return false;
    }

    private BlockPos getNextIndexToFill(boolean remove) {
        if (this.pumpLayerQueues.isEmpty()) {
            return null;
        }
        Deque<BlockPos> bottomLayer = this.pumpLayerQueues.firstEntry().getValue();
        if (bottomLayer != null) {
            if (bottomLayer.isEmpty()) {
                this.pumpLayerQueues.pollFirstEntry();
            }
            if (remove) {
                BlockPos index = bottomLayer.pollFirst();
                return index;
            }
            return bottomLayer.peekFirst();
        }
        return null;
    }

    private Deque<BlockPos> getLayerQueue(int layer) {
        Deque<BlockPos> pumpQueue = this.pumpLayerQueues.get(layer);
        if (pumpQueue == null) {
            pumpQueue = new LinkedList<BlockPos>();
            this.pumpLayerQueues.put(layer, pumpQueue);
        }
        return pumpQueue;
    }

    public void rebuildQueue() {
        this.pumpLayerQueues.clear();
        this.visitedBlocks.clear();
        this.fluidsFound.clear();
        this.queueAdjacent(this.field_174879_c);
        this.expandQueue();
    }

    private void expandQueue() {
        if (this.tank.getFluidType() == null) {
            return;
        }
        while (!this.fluidsFound.isEmpty()) {
            Deque<BlockPos> fluidsToExpand = this.fluidsFound;
            this.fluidsFound = new LinkedList<BlockPos>();
            for (BlockPos index : fluidsToExpand) {
                this.queueAdjacent(index);
            }
        }
    }

    public void queueAdjacent(BlockPos pos) {
        if (this.tank.getFluidType() == null) {
            return;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (face == EnumFacing.UP || this.blockedSides.get(face).booleanValue()) continue;
            this.queueForFilling(pos.func_177972_a(face));
        }
    }

    public void queueForFilling(BlockPos pos) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() > 255) {
            return;
        }
        if (this.visitedBlocks.add(pos)) {
            if ((pos.func_177958_n() - this.field_174879_c.func_177958_n()) * (pos.func_177958_n() - this.field_174879_c.func_177958_n()) + (pos.func_177952_p() - this.field_174879_c.func_177952_p()) * (pos.func_177952_p() - this.field_174879_c.func_177952_p()) > 4096) {
                return;
            }
            Block block = BlockUtils.getBlockState(this.field_145850_b, pos).func_177230_c();
            if (BlockUtils.getFluid(block) == this.tank.getFluidType()) {
                this.fluidsFound.add(pos);
            }
            if (this.canPlaceFluidAt(block, pos)) {
                this.getLayerQueue(pos.func_177956_o()).addLast(pos);
            }
        }
    }

    private boolean canPlaceFluidAt(Block block, BlockPos pos) {
        return BuildCraftAPI.isSoftBlock(this.field_145850_b, pos) && !BlockUtils.isFullFluidBlock(this.field_145850_b, pos);
    }

    public void onNeighborBlockChange(Block block) {
        boolean p;
        boolean bl = p = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        if (this.powered != p) {
            this.powered = p;
            if (!p) {
                this.rebuildQueue();
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tank.readFromNBT(data);
        this.rebuildDelay = data.func_74771_c("rebuildDelay");
        this.powered = data.func_74767_n("powered");
        for (int i = 0; i < 6; ++i) {
            this.blockedSides.put(EnumFacing.field_82609_l[i], data.func_74767_n("blocked[" + i + "]"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tank.writeToNBT(data);
        data.func_74774_a("rebuildDelay", (byte)this.rebuildDelay);
        data.func_74757_a("powered", this.powered);
        for (int i = 0; i < 6; ++i) {
            if (!this.blockedSides.get(EnumFacing.field_82609_l[i]).booleanValue()) continue;
            data.func_74757_a("blocked[" + i + "]", true);
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        byte data = stream.readByte();
        EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
        int n = enumFacingArray.length;
        for (int i = 0; i < n; ++i) {
            EnumFacing face;
            int offset = (face = enumFacingArray[i]).ordinal();
            int isBlocked = (data >> offset) % 2;
            this.blockedSides.put(face, isBlocked != 0);
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        int offset = 0;
        int data = 0;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int isBlocked = this.blockedSides.get(face) != false ? 1 : 0;
            data = (byte)(data & isBlocked << offset);
            ++offset;
        }
        stream.writeByte(data);
    }

    public void switchSide(EnumFacing side) {
        if (side != EnumFacing.UP) {
            this.blockedSides.put(side, this.blockedSides.get(side) == false);
            this.rebuildQueue();
            this.sendNetworkUpdate();
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    @Override
    public void destroy() {
        this.pumpLayerQueues.clear();
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public boolean isSideBlocked(EnumFacing face) {
        return this.blockedSides.get(face);
    }

    static {
        TileFloodGate.REBUILD_DELAY[0] = 128;
        TileFloodGate.REBUILD_DELAY[1] = 256;
        TileFloodGate.REBUILD_DELAY[2] = 512;
        TileFloodGate.REBUILD_DELAY[3] = 1024;
        TileFloodGate.REBUILD_DELAY[4] = 2048;
        TileFloodGate.REBUILD_DELAY[5] = 4096;
        TileFloodGate.REBUILD_DELAY[6] = 8192;
        TileFloodGate.REBUILD_DELAY[7] = 16384;
    }
}

