/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.utils.BlockMiner;
import buildcraft.core.lib.utils.BlockUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class TileMiningWell
extends TileBuildCraft
implements IHasWork,
IPipeConnection,
IControllable {
    private boolean isDigging = true;
    private BlockMiner miner;
    private int ledState;
    private int ticksSinceAction = 9001;
    private SafeTimeTracker updateTracker = new SafeTimeTracker(BuildCraftCore.updateFactor);

    public TileMiningWell() {
        this.setBattery(new RFBattery(20480, 880, 0));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.updateTracker.markTimeIfDelay(this.field_145850_b)) {
            this.sendNetworkUpdate();
        }
        ++this.ticksSinceAction;
        if (this.mode == IControllable.Mode.Off) {
            if (this.miner != null) {
                this.miner.invalidate();
                this.miner = null;
            }
            this.isDigging = false;
            return;
        }
        if (this.getBattery().getEnergyStored() == 0) {
            return;
        }
        if (this.miner == null) {
            World world = this.field_145850_b;
            BlockPos search = this.field_174879_c.func_177977_b();
            while (world.func_180495_p(search).func_177230_c() == BuildCraftFactory.plainPipeBlock) {
                search = search.func_177977_b();
            }
            if (search.func_177956_o() < 1 || search.func_177956_o() < this.field_174879_c.func_177956_o() - BuildCraftFactory.miningDepth || !BlockUtils.canChangeBlock(world, search)) {
                this.isDigging = false;
                this.getBattery().useEnergy(0, 10, false);
                return;
            }
            if (world.func_175623_d(search) || world.func_180495_p(search).func_177230_c().func_176200_f(world, search)) {
                this.ticksSinceAction = 0;
                world.func_175656_a(search, BuildCraftFactory.plainPipeBlock.func_176223_P());
            } else {
                this.miner = new BlockMiner(world, this, search);
            }
        }
        if (this.miner != null) {
            this.isDigging = true;
            this.ticksSinceAction = 0;
            int usedEnergy = this.miner.acceptEnergy(this.getBattery().getEnergyStored());
            this.getBattery().useEnergy(usedEnergy, usedEnergy, false);
            if (this.miner.hasFailed()) {
                this.isDigging = false;
            }
            if (this.miner.hasFailed() || this.miner.hasMined()) {
                this.miner = null;
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.miner != null) {
            this.miner.invalidate();
        }
        if (this.field_145850_b != null && this.field_174879_c.func_177956_o() > 2) {
            BuildCraftFactory.miningWellBlock.removePipes(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        this.ledState = (this.ticksSinceAction < 2 ? 16 : 0) | this.getBattery().getEnergyStored() * 15 / this.getBattery().getMaxEnergyStored();
        stream.writeByte(this.ledState);
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        short newLedState = stream.readUnsignedByte();
        if (newLedState != this.ledState) {
            this.ledState = newLedState;
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    @Override
    public boolean hasWork() {
        return this.isDigging;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, EnumFacing with) {
        return type == IPipeTile.PipeType.ITEM ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On;
    }
}

