/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.TileBuffer;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.fluids.SingleUseTank;
import buildcraft.core.lib.fluids.TankUtils;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.factory.FactoryProxy;
import io.netty.buffer.ByteBuf;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TilePump
extends TileBuildCraft
implements IHasWork,
IFluidHandler,
IRedstoneEngineReceiver {
    public static final int REBUID_DELAY = 512;
    public static int MAX_LIQUID = 16000;
    public SingleUseTank tank = new SingleUseTank("tank", MAX_LIQUID, this);
    private EntityResizableCuboid tube;
    private TreeMap<Integer, Deque<BlockPos>> pumpLayerQueues = new TreeMap();
    private double tubeY = Double.NaN;
    private int aimY = 0;
    private SafeTimeTracker timer = new SafeTimeTracker(512L);
    private int tick = Utils.RANDOM.nextInt(32);
    private int tickPumped = this.tick - 20;
    private int numFluidBlocksFound = 0;
    private boolean powered = false;
    private int ledState;
    private SafeTimeTracker updateTracker = new SafeTimeTracker(Math.max(16, BuildCraftCore.updateFactor));

    public TilePump() {
        this.setBattery(new RFBattery(1000, 150, 0));
    }

    @Override
    public void func_73660_a() {
        FluidStack fluidToPump;
        super.func_73660_a();
        if (this.powered) {
            this.pumpLayerQueues.clear();
            this.destroyTube();
        } else {
            this.createTube();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.updateTracker.markTimeIfDelay(this.field_145850_b)) {
            this.sendNetworkUpdate();
        }
        this.pushToConsumers();
        if (this.powered) {
            return;
        }
        if (this.tube == null) {
            return;
        }
        if (this.tube.field_70163_u - (double)this.aimY > 0.01) {
            this.tubeY = this.tube.field_70163_u - 0.01;
            this.setTubePosition();
            this.sendNetworkUpdate();
            return;
        }
        ++this.tick;
        if (this.tick % 16 != 0) {
            return;
        }
        BlockPos index = this.getNextIndexToPump(false);
        FluidStack fluidStack = fluidToPump = index != null ? BlockUtils.drainBlock(this.field_145850_b, index, false) : null;
        if (fluidToPump != null) {
            if (this.isFluidAllowed(fluidToPump.getFluid()) && this.tank.fill(fluidToPump, false) == fluidToPump.amount && this.getBattery().useEnergy(100, 100, false) > 0) {
                if (fluidToPump.getFluid() != FluidRegistry.WATER || BuildCraftCore.consumeWaterSources || this.numFluidBlocksFound < 9) {
                    index = this.getNextIndexToPump(true);
                    BlockUtils.drainBlock(this.field_145850_b, index, true);
                }
                this.tank.fill(fluidToPump, true);
                this.tickPumped = this.tick;
            }
        } else if (this.tick % 128 == 0) {
            this.rebuildQueue();
            if (this.getNextIndexToPump(false) == null) {
                for (int y = 1; y < this.field_174879_c.func_177956_o(); ++y) {
                    BlockPos pos2 = this.field_174879_c.func_177979_c(y);
                    if (this.isPumpableFluid(pos2)) {
                        this.aimY = pos2.func_177956_o();
                        return;
                    }
                    if (!this.isBlocked(pos2)) continue;
                    return;
                }
            }
        }
    }

    public void onNeighborBlockChange(Block block) {
        boolean p;
        boolean bl = p = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        if (this.powered != p) {
            this.powered = p;
            if (!this.field_145850_b.field_72995_K) {
                this.sendNetworkUpdate();
            }
        }
    }

    private boolean isBlocked(BlockPos pos) {
        Material mat = BlockUtils.getBlockState(this.field_145850_b, pos).func_177230_c().func_149688_o();
        return mat.func_76230_c();
    }

    private void pushToConsumers() {
        if (this.cache == null) {
            this.cache = TileBuffer.makeBuffer(this.field_145850_b, this.field_174879_c, false);
        }
        TankUtils.pushFluidToConsumers((IFluidTank)this.tank, 400, this.cache);
    }

    private void createTube() {
        if (this.tube == null) {
            this.tube = FactoryProxy.proxy.newPumpTube(this.field_145850_b);
            this.tube.field_70163_u = !Double.isNaN(this.tubeY) ? this.tubeY : (double)this.field_174879_c.func_177956_o();
            this.tubeY = this.tube.field_70163_u;
            if (this.aimY == 0) {
                this.aimY = this.field_174879_c.func_177956_o();
            }
            this.setTubePosition();
            this.field_145850_b.func_72838_d((Entity)this.tube);
            if (!this.field_145850_b.field_72995_K) {
                this.sendNetworkUpdate();
            }
        }
    }

    private void destroyTube() {
        if (this.tube != null) {
            CoreProxy.proxy.removeEntity(this.tube);
            this.tube = null;
            this.tubeY = Double.NaN;
            this.aimY = 0;
        }
    }

    private BlockPos getNextIndexToPump(boolean remove) {
        if (this.pumpLayerQueues.isEmpty()) {
            if (this.timer.markTimeIfDelay(this.field_145850_b)) {
                this.rebuildQueue();
            }
            return null;
        }
        Deque<BlockPos> topLayer = this.pumpLayerQueues.lastEntry().getValue();
        if (topLayer != null) {
            if (topLayer.isEmpty()) {
                this.pumpLayerQueues.pollLastEntry();
            }
            if (remove) {
                BlockPos index = topLayer.pollLast();
                return index;
            }
            return topLayer.peekLast();
        }
        return null;
    }

    private Deque<BlockPos> getLayerQueue(int layer) {
        Deque<BlockPos> pumpQueue = this.pumpLayerQueues.get(layer);
        if (pumpQueue == null) {
            pumpQueue = new LinkedList<BlockPos>();
            this.pumpLayerQueues.put(layer, pumpQueue);
        }
        return pumpQueue;
    }

    public void rebuildQueue() {
        this.numFluidBlocksFound = 0;
        this.pumpLayerQueues.clear();
        int x = this.field_174879_c.func_177958_n();
        int y = this.aimY;
        int z = this.field_174879_c.func_177952_p();
        BlockPos pos = new BlockPos(x, y, z);
        Fluid pumpingFluid = BlockUtils.getFluid(BlockUtils.getBlockState(this.field_145850_b, pos).func_177230_c());
        if (pumpingFluid == null) {
            return;
        }
        if (pumpingFluid != this.tank.getAcceptedFluid() && this.tank.getAcceptedFluid() != null) {
            return;
        }
        HashSet<BlockPos> visitedBlocks = new HashSet<BlockPos>();
        LinkedList<Object> fluidsFound = new LinkedList<BlockPos>();
        this.queueForPumping(pos, visitedBlocks, fluidsFound, pumpingFluid);
        while (!fluidsFound.isEmpty()) {
            LinkedList<BlockPos> fluidsToExpand = fluidsFound;
            fluidsFound = new LinkedList();
            for (BlockPos index : fluidsToExpand) {
                this.queueForPumping(index.func_177984_a(), visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.func_177974_f(), visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.func_177976_e(), visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.func_177978_c(), visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.func_177968_d(), visitedBlocks, fluidsFound, pumpingFluid);
                if (pumpingFluid != FluidRegistry.WATER || BuildCraftCore.consumeWaterSources || this.numFluidBlocksFound < 9) continue;
                return;
            }
        }
    }

    public void queueForPumping(BlockPos pos, Set<BlockPos> visitedBlocks, Deque<BlockPos> fluidsFound, Fluid pumpingFluid) {
        BlockPos index = new BlockPos((Vec3i)pos);
        if (visitedBlocks.add(index)) {
            if ((pos.func_177958_n() - this.field_174879_c.func_177958_n()) * (pos.func_177958_n() - this.field_174879_c.func_177958_n()) + (pos.func_177952_p() - this.field_174879_c.func_177952_p()) * (pos.func_177952_p() - this.field_174879_c.func_177952_p()) > 4096) {
                return;
            }
            IBlockState state = BlockUtils.getBlockState(this.field_145850_b, pos);
            if (BlockUtils.getFluid(state.func_177230_c()) == pumpingFluid) {
                fluidsFound.add(index);
            }
            if (this.canDrainBlock(state, pos, pumpingFluid)) {
                this.getLayerQueue(pos.func_177956_o()).add(index);
                ++this.numFluidBlocksFound;
            }
        }
    }

    private boolean isPumpableFluid(BlockPos pos) {
        Fluid fluid = BlockUtils.getFluid(BlockUtils.getBlockState(this.field_145850_b, pos).func_177230_c());
        if (fluid == null) {
            return false;
        }
        if (!this.isFluidAllowed(fluid)) {
            return false;
        }
        return this.tank.getAcceptedFluid() == null || this.tank.getAcceptedFluid() == fluid;
    }

    private boolean canDrainBlock(IBlockState state, BlockPos pos, Fluid fluid) {
        if (!this.isFluidAllowed(fluid)) {
            return false;
        }
        FluidStack fluidStack = BlockUtils.drainBlock(state, this.field_145850_b, pos, false);
        if (fluidStack == null || fluidStack.amount <= 0) {
            return false;
        }
        return fluidStack.getFluid() == fluid;
    }

    private boolean isFluidAllowed(Fluid fluid) {
        return BuildCraftFactory.pumpDimensionList.isFluidAllowed(fluid, this.field_145850_b.field_73011_w.func_177502_q());
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tank.readFromNBT(data);
        this.powered = data.func_74767_n("powered");
        this.aimY = data.func_74762_e("aimY");
        this.tubeY = data.func_74760_g("tubeY");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tank.writeToNBT(data);
        data.func_74757_a("powered", this.powered);
        data.func_74768_a("aimY", this.aimY);
        if (this.tube != null) {
            data.func_74776_a("tubeY", (float)this.tube.field_70163_u);
        } else {
            data.func_74776_a("tubeY", (float)this.field_174879_c.func_177956_o());
        }
    }

    @Override
    public boolean hasWork() {
        BlockPos next = this.getNextIndexToPump(false);
        if (next != null) {
            return this.isPumpableFluid(next);
        }
        return false;
    }

    @Override
    public void writeData(ByteBuf buf) {
        buf.writeShort(this.aimY);
        buf.writeFloat((float)this.tubeY);
        buf.writeBoolean(this.powered);
        this.ledState = (this.tick - this.tickPumped < 48 ? 16 : 0) | this.getBattery().getEnergyStored() * 15 / this.getBattery().getMaxEnergyStored();
        buf.writeByte(this.ledState);
    }

    @Override
    public void readData(ByteBuf data) {
        this.aimY = data.readShort();
        this.tubeY = data.readFloat();
        this.powered = data.readBoolean();
        short newLedState = data.readUnsignedByte();
        if (newLedState != this.ledState) {
            this.ledState = newLedState;
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
        this.setTubePosition();
    }

    private void setTubePosition() {
        if (this.tube != null) {
            this.tube.xSize = 0.5;
            this.tube.zSize = 0.5;
            this.tube.ySize = (double)this.field_174879_c.func_177956_o() - this.tube.field_70163_u;
            this.tube.func_70107_b((float)this.field_174879_c.func_177958_n() + 0.25f, this.tubeY, (float)this.field_174879_c.func_177952_p() + 0.25f);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.tube != null) {
            CoreProxy.proxy.removeEntity(this.tube);
            this.tube = null;
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
    }

    @Override
    public void destroy() {
        this.pumpLayerQueues.clear();
        this.destroyTube();
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public boolean canConnectRedstoneEngine(EnumFacing side) {
        return !BuildCraftFactory.pumpsNeedRealPower;
    }
}

