/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftRobotics;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.gates.IGate;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.robots.RobotManager;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.inventory.InventoryWrapper;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.ActionIterator;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeItemsWood;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.fluids.IFluidHandler;

public class DockingStationPipe
extends DockingStation
implements IRequestProvider {
    private IInjectable injectablePipe = new IInjectable(){

        @Override
        public boolean canInjectItems(EnumFacing from) {
            return true;
        }

        @Override
        public int injectItem(ItemStack stack, boolean doAdd, EnumFacing from, EnumDyeColor color) {
            if (doAdd) {
                Vec3 vec = Utils.convertMiddle((Vec3i)DockingStationPipe.this.getPos()).func_178787_e(Utils.convert(DockingStationPipe.this.side, 0.2));
                TravelingItem item = TravelingItem.make(vec, stack);
                ((PipeTransportItems)((Pipe)DockingStationPipe.this.getPipe().getPipe()).transport).injectItem(item, from);
            }
            return stack.field_77994_a;
        }
    };
    private IPipeTile pipe;

    public DockingStationPipe() {
    }

    public DockingStationPipe(IPipeTile iPipe, EnumFacing side) {
        super(((TileEntity)iPipe).func_174877_v(), side);
        this.pipe = iPipe;
        this.world = iPipe.getWorldBC();
    }

    public IPipeTile getPipe() {
        TileEntity tile;
        if (this.pipe == null && (tile = this.world.func_175625_s(this.getPos())) instanceof IPipeTile) {
            this.pipe = (IPipeTile)tile;
        }
        if (this.pipe == null || ((TileEntity)this.pipe).func_145837_r()) {
            RobotManager.registryProvider.getRegistry(this.world).removeStation(this);
            this.pipe = null;
        }
        return this.pipe;
    }

    @Override
    public Iterable<StatementSlot> getActiveActions() {
        return new ActionIterator(this.getPipe().getPipe());
    }

    @Override
    public IInjectable getItemOutput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.ITEM) {
            return null;
        }
        return this.injectablePipe;
    }

    @Override
    public EnumPipePart getItemOutputSide() {
        return EnumPipePart.fromFacing(this.side().func_176734_d());
    }

    public ISidedInventory getItemInput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.ITEM) {
            return null;
        }
        if (!(this.getPipe().getPipe() instanceof PipeItemsWood)) {
            return null;
        }
        int meta = ((TileEntity)this.getPipe()).func_145832_p();
        EnumFacing dir = EnumFacing.func_82600_a((int)meta);
        TileEntity connectedTile = this.getPipe().getWorldBC().func_175625_s(this.getPos().func_177971_a((Vec3i)Utils.convertFloor(dir)));
        if (connectedTile instanceof IInventory) {
            return InventoryWrapper.getWrappedInventory(connectedTile);
        }
        return null;
    }

    @Override
    public EnumPipePart getItemInputSide() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.ITEM) {
            return EnumPipePart.CENTER;
        }
        if (!(this.getPipe().getPipe() instanceof PipeItemsWood)) {
            return EnumPipePart.CENTER;
        }
        int meta = ((TileEntity)this.getPipe()).func_145832_p();
        return EnumPipePart.fromMeta(meta).opposite();
    }

    @Override
    public IFluidHandler getFluidInput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.FLUID) {
            return null;
        }
        if (!(this.getPipe().getPipe() instanceof PipeFluidsWood)) {
            return null;
        }
        int meta = ((TileEntity)this.getPipe()).func_145832_p();
        EnumFacing dir = EnumFacing.func_82600_a((int)meta);
        TileEntity connectedTile = this.getPipe().getWorldBC().func_175625_s(this.getPos().func_177971_a((Vec3i)Utils.convertFloor(dir)));
        if (connectedTile instanceof IFluidHandler) {
            return (IFluidHandler)connectedTile;
        }
        return null;
    }

    @Override
    public EnumPipePart getFluidInputSide() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.FLUID) {
            return EnumPipePart.CENTER;
        }
        if (!(this.getPipe().getPipe() instanceof PipeFluidsWood)) {
            return EnumPipePart.CENTER;
        }
        int meta = ((TileEntity)this.getPipe()).func_145832_p();
        return EnumPipePart.fromMeta(meta).opposite();
    }

    @Override
    public IFluidHandler getFluidOutput() {
        if (this.getPipe().getPipeType() != IPipeTile.PipeType.FLUID) {
            return null;
        }
        return (IFluidHandler)((Pipe)this.getPipe().getPipe()).transport;
    }

    @Override
    public EnumPipePart getFluidOutputSide() {
        return EnumPipePart.CENTER;
    }

    @Override
    public boolean providesPower() {
        return this.getPipe().getPipeType() == IPipeTile.PipeType.POWER;
    }

    @Override
    public IRequestProvider getRequestProvider() {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity nearbyTile = this.getPipe().getWorldBC().func_175625_s(this.getPos().func_177971_a((Vec3i)Utils.convertFloor(dir)));
            if (!(nearbyTile instanceof IRequestProvider)) continue;
            return (IRequestProvider)nearbyTile;
        }
        return this;
    }

    @Override
    public boolean isInitialized() {
        if (this.getPipe() == null || this.getPipe().getPipe() == null) {
            return false;
        }
        return ((Pipe)this.getPipe().getPipe()).isInitialized();
    }

    @Override
    public boolean take(EntityRobotBase robot) {
        boolean result = super.take(robot);
        if (result) {
            this.getPipe().scheduleRenderUpdate();
        }
        return result;
    }

    @Override
    public boolean takeAsMain(EntityRobotBase robot) {
        boolean result = super.takeAsMain(robot);
        if (result) {
            this.getPipe().scheduleRenderUpdate();
        }
        return result;
    }

    @Override
    public void unsafeRelease(EntityRobotBase robot) {
        super.unsafeRelease(robot);
        if (this.robotTaking() == null && this.getPipe() != null) {
            this.getPipe().scheduleRenderUpdate();
        }
    }

    @Override
    public void onChunkUnload() {
        this.pipe = null;
    }

    @Override
    public int getRequestsCount() {
        return 127;
    }

    @Override
    public ItemStack getRequest(int slot) {
        EnumFacing side = EnumFacing.values()[(slot & 0x70) >> 4];
        int action = (slot & 0xC) >> 2;
        int param = slot & 3;
        IGate gate = this.getPipe().getPipe().getGate(side);
        if (gate == null) {
            return null;
        }
        List<IStatement> actions = gate.getActions();
        if (actions.size() <= action) {
            return null;
        }
        if (actions.get(action) != BuildCraftRobotics.actionStationRequestItems) {
            return null;
        }
        List<StatementSlot> activeActions = gate.getActiveActions();
        StatementSlot slotStmt = null;
        for (StatementSlot stmt : activeActions) {
            if (stmt.statement != actions.get(action)) continue;
            slotStmt = stmt;
            break;
        }
        if (slotStmt == null) {
            return null;
        }
        if (slotStmt.parameters.length <= param) {
            return null;
        }
        if (slotStmt.parameters[param] == null) {
            return null;
        }
        return slotStmt.parameters[param].getItemStack();
    }

    @Override
    public ItemStack offerItem(int slot, ItemStack stack) {
        int consumed = this.injectablePipe.injectItem(stack, true, this.side.func_176734_d(), null);
        if (stack.field_77994_a > consumed) {
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a -= consumed;
            return newStack;
        }
        return null;
    }
}

