/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.api.core.BCLog;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRobotRegistry;
import buildcraft.api.robots.ResourceId;
import buildcraft.api.robots.RobotManager;
import buildcraft.robotics.DockingStationPipe;
import buildcraft.robotics.EntityRobot;
import buildcraft.robotics.StationIndex;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RobotRegistry
extends WorldSavedData
implements IRobotRegistry {
    protected World world;
    protected final HashMap<StationIndex, DockingStation> stations = new HashMap();
    private long nextRobotID = Long.MIN_VALUE;
    private final LongHashMap robotsLoaded = new LongHashMap();
    private final HashSet<EntityRobot> robotsLoadedSet = new HashSet();
    private final HashMap<ResourceId, Long> resourcesTaken = new HashMap();
    private final LongHashMap resourcesTakenByRobot = new LongHashMap();
    private final LongHashMap stationsTakenByRobot = new LongHashMap();

    public RobotRegistry(String id) {
        super(id);
    }

    @Override
    public long getNextRobotId() {
        long result = this.nextRobotID++;
        return result;
    }

    @Override
    public void registerRobot(EntityRobotBase robot) {
        this.func_76185_a();
        if (robot.getRobotId() == Long.MAX_VALUE) {
            ((EntityRobot)robot).setUniqueRobotId(this.getNextRobotId());
        }
        if (this.robotsLoaded.func_76161_b(robot.getRobotId())) {
            BCLog.logger.warn("Robot with id %d was not unregistered properly", new Object[]{robot.getRobotId()});
        }
        this.addRobotLoaded((EntityRobot)robot);
    }

    private HashSet<ResourceId> getResourcesTakenByRobot(long robotId) {
        return (HashSet)this.resourcesTakenByRobot.func_76164_a(robotId);
    }

    private HashSet<StationIndex> getStationsTakenByRobot(long robotId) {
        return (HashSet)this.stationsTakenByRobot.func_76164_a(robotId);
    }

    private void addRobotLoaded(EntityRobot robot) {
        this.robotsLoaded.func_76163_a(robot.getRobotId(), (Object)robot);
        this.robotsLoadedSet.add(robot);
    }

    private void removeRobotLoaded(EntityRobot robot) {
        this.robotsLoaded.func_76159_d(robot.getRobotId());
        this.robotsLoadedSet.remove(robot);
    }

    @Override
    public void killRobot(EntityRobotBase robot) {
        this.func_76185_a();
        this.releaseResources(robot, true);
        this.removeRobotLoaded((EntityRobot)robot);
    }

    @Override
    public void unloadRobot(EntityRobotBase robot) {
        this.func_76185_a();
        this.releaseResources(robot, false, true);
        this.removeRobotLoaded((EntityRobot)robot);
    }

    @Override
    public EntityRobot getLoadedRobot(long id) {
        if (this.robotsLoaded.func_76161_b(id)) {
            return (EntityRobot)this.robotsLoaded.func_76164_a(id);
        }
        return null;
    }

    @Override
    public synchronized boolean isTaken(ResourceId resourceId) {
        return this.robotIdTaking(resourceId) != Long.MAX_VALUE;
    }

    @Override
    public synchronized long robotIdTaking(ResourceId resourceId) {
        if (!this.resourcesTaken.containsKey(resourceId)) {
            return Long.MAX_VALUE;
        }
        long robotId = this.resourcesTaken.get(resourceId);
        if (this.robotsLoaded.func_76161_b(robotId) && !((EntityRobot)this.robotsLoaded.func_76164_a((long)robotId)).field_70128_L) {
            return robotId;
        }
        this.release(resourceId);
        return Long.MAX_VALUE;
    }

    @Override
    public synchronized EntityRobot robotTaking(ResourceId resourceId) {
        long robotId = this.robotIdTaking(resourceId);
        if (robotId == Long.MAX_VALUE || !this.robotsLoaded.func_76161_b(robotId)) {
            return null;
        }
        return (EntityRobot)this.robotsLoaded.func_76164_a(robotId);
    }

    @Override
    public synchronized boolean take(ResourceId resourceId, EntityRobotBase robot) {
        this.func_76185_a();
        return this.take(resourceId, robot.getRobotId());
    }

    @Override
    public synchronized boolean take(ResourceId resourceId, long robotId) {
        if (resourceId == null) {
            return false;
        }
        this.func_76185_a();
        if (!this.resourcesTaken.containsKey(resourceId)) {
            this.resourcesTaken.put(resourceId, robotId);
            if (!this.resourcesTakenByRobot.func_76161_b(robotId)) {
                this.resourcesTakenByRobot.func_76163_a(robotId, new HashSet());
            }
            this.getResourcesTakenByRobot(robotId).add(resourceId);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void release(ResourceId resourceId) {
        if (resourceId == null) {
            return;
        }
        this.func_76185_a();
        if (this.resourcesTaken.containsKey(resourceId)) {
            long robotId = this.resourcesTaken.get(resourceId);
            this.getResourcesTakenByRobot(robotId).remove(resourceId);
            this.resourcesTaken.remove(resourceId);
        }
    }

    @Override
    public synchronized void releaseResources(EntityRobotBase robot) {
        this.releaseResources(robot, false);
    }

    private synchronized void releaseResources(EntityRobotBase robot, boolean forceAll) {
        this.releaseResources(robot, forceAll, false);
    }

    private synchronized void releaseResources(EntityRobotBase robot, boolean forceAll, boolean resetEntities) {
        this.func_76185_a();
        if (this.resourcesTakenByRobot.func_76161_b(robot.getRobotId())) {
            HashSet resourceSet = (HashSet)this.getResourcesTakenByRobot(robot.getRobotId()).clone();
            for (ResourceId id : resourceSet) {
                this.release(id);
            }
            this.resourcesTakenByRobot.func_76159_d(robot.getRobotId());
        }
        if (this.stationsTakenByRobot.func_76161_b(robot.getRobotId())) {
            HashSet stationSet = (HashSet)this.getStationsTakenByRobot(robot.getRobotId()).clone();
            for (StationIndex s : stationSet) {
                DockingStation d = this.stations.get(s);
                if (d == null) continue;
                if (!d.canRelease()) {
                    if (forceAll) {
                        d.unsafeRelease(robot);
                        continue;
                    }
                    if (!resetEntities || d.robotIdTaking() != robot.getRobotId()) continue;
                    d.invalidateRobotTakingEntity();
                    continue;
                }
                d.unsafeRelease(robot);
            }
            if (forceAll) {
                this.stationsTakenByRobot.func_76159_d(robot.getRobotId());
            }
        }
    }

    @Override
    public synchronized DockingStation getStation(BlockPos pos, EnumFacing side) {
        StationIndex index = new StationIndex(side, pos);
        if (this.stations.containsKey(index)) {
            return this.stations.get(index);
        }
        return null;
    }

    @Override
    public synchronized Collection<DockingStation> getStations() {
        return this.stations.values();
    }

    @Override
    public synchronized void registerStation(DockingStation station) {
        this.func_76185_a();
        StationIndex index = new StationIndex(station);
        if (this.stations.containsKey(index)) {
            throw new InvalidParameterException("Station " + index + " already registered");
        }
        this.stations.put(index, station);
    }

    @Override
    public synchronized void removeStation(DockingStation station) {
        this.func_76185_a();
        StationIndex index = new StationIndex(station);
        if (this.stations.containsKey(index)) {
            if (station.robotTaking() != null) {
                if (!station.isMainStation()) {
                    station.robotTaking().undock();
                } else {
                    station.robotTaking().setMainStation(null);
                }
            } else if (station.robotIdTaking() != Long.MAX_VALUE && this.stationsTakenByRobot.func_76161_b(station.robotIdTaking())) {
                this.getStationsTakenByRobot(station.robotIdTaking()).remove(index);
            }
            this.stations.remove(index);
        }
    }

    @Override
    public synchronized void take(DockingStation station, long robotId) {
        if (!this.stationsTakenByRobot.func_76161_b(robotId)) {
            this.stationsTakenByRobot.func_76163_a(robotId, new HashSet());
        }
        this.getStationsTakenByRobot(robotId).add(new StationIndex(station));
    }

    @Override
    public synchronized void release(DockingStation station, long robotId) {
        if (this.stationsTakenByRobot.func_76161_b(robotId)) {
            this.getStationsTakenByRobot(robotId).remove(new StationIndex(station));
        }
    }

    public synchronized void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74772_a("nextRobotID", this.nextRobotID);
        NBTTagList resourceList = new NBTTagList();
        for (Map.Entry<ResourceId, Long> e : this.resourcesTaken.entrySet()) {
            NBTTagCompound cpt = new NBTTagCompound();
            NBTTagCompound resourceId = new NBTTagCompound();
            e.getKey().writeToNBT(resourceId);
            cpt.func_74782_a("resourceId", (NBTBase)resourceId);
            cpt.func_74772_a("robotId", e.getValue().longValue());
            resourceList.func_74742_a((NBTBase)cpt);
        }
        nbt.func_74782_a("resourceList", (NBTBase)resourceList);
        NBTTagList stationList = new NBTTagList();
        for (Map.Entry<StationIndex, DockingStation> e : this.stations.entrySet()) {
            NBTTagCompound cpt = new NBTTagCompound();
            e.getValue().writeToNBT(cpt);
            cpt.func_74778_a("stationType", RobotManager.getDockingStationName(e.getValue().getClass()));
            stationList.func_74742_a((NBTBase)cpt);
        }
        nbt.func_74782_a("stationList", (NBTBase)stationList);
    }

    public synchronized void func_76184_a(NBTTagCompound nbt) {
        this.nextRobotID = nbt.func_74763_f("nextRobotID");
        NBTTagList resourceList = nbt.func_150295_c("resourceList", 10);
        for (int i = 0; i < resourceList.func_74745_c(); ++i) {
            NBTTagCompound cpt = resourceList.func_150305_b(i);
            ResourceId resourceId = ResourceId.load(cpt.func_74775_l("resourceId"));
            long robotId = cpt.func_74763_f("robotId");
            this.take(resourceId, robotId);
        }
        NBTTagList stationList = nbt.func_150295_c("stationList", 10);
        for (int i = 0; i < stationList.func_74745_c(); ++i) {
            Class cls;
            NBTTagCompound cpt = stationList.func_150305_b(i);
            if (!cpt.func_74764_b("stationType")) {
                cls = DockingStationPipe.class;
            } else {
                cls = RobotManager.getDockingStationByName(cpt.func_74779_i("stationType"));
                if (cls == null) {
                    BCLog.logger.error("Could not load docking station of type " + nbt.func_74779_i("stationType"));
                    continue;
                }
            }
            try {
                DockingStation station = (DockingStation)cls.newInstance();
                station.readFromNBT(cpt);
                this.registerStation(station);
                if (station.linkedId() == Long.MAX_VALUE) continue;
                this.take(station, station.linkedId());
                continue;
            }
            catch (Exception e) {
                BCLog.logger.error("Could not load docking station", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload e) {
        if (e.world == this.world) {
            for (EntityRobot robot : new ArrayList<EntityRobot>(this.robotsLoadedSet)) {
                if (e.world.field_72996_f.contains(robot)) continue;
                robot.onChunkUnload();
            }
            for (DockingStation station : new ArrayList<DockingStation>(this.stations.values())) {
                if (!this.world.func_175623_d(station.getPos())) continue;
                station.onChunkUnload();
            }
        }
    }

    @Override
    public void registryMarkDirty() {
        this.func_76185_a();
    }
}

