/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftRobotics;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.IDockingStationProvider;
import buildcraft.api.robots.RobotManager;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableItem;
import buildcraft.api.transport.pluggable.IPipePluggableStaticRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.robotics.DockingStationPipe;
import buildcraft.robotics.EntityRobot;
import buildcraft.robotics.render.RobotStationRenderer;
import cofh.api.energy.IEnergyReceiver;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;

public class RobotStationPluggable
extends PipePluggable
implements IPipePluggableItem,
IEnergyReceiver,
IDebuggable,
IDockingStationProvider {
    private EnumRobotStationState renderState;
    private DockingStationPipe station;
    private boolean isValid = false;

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        return new ItemStack[]{new ItemStack(BuildCraftRobotics.robotStationItem)};
    }

    @Override
    public DockingStation getStation() {
        return this.station;
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, EnumFacing direction) {
        return true;
    }

    @Override
    public void invalidate() {
        if (this.station != null && this.station.getPipe() != null && !this.station.getPipe().getWorldBC().field_72995_K) {
            RobotManager.registryProvider.getRegistry(this.station.world).removeStation(this.station);
            this.isValid = false;
        }
    }

    @Override
    public void validate(IPipeTile pipe, EnumFacing direction) {
        if (!this.isValid && !pipe.getWorldBC().field_72995_K) {
            this.station = (DockingStationPipe)RobotManager.registryProvider.getRegistry(pipe.getWorldBC()).getStation(((TileEntity)pipe).func_174877_v(), direction);
            if (this.station == null) {
                this.station = new DockingStationPipe(pipe, direction);
                RobotManager.registryProvider.getRegistry(pipe.getWorldBC()).registerStation(this.station);
            }
            this.isValid = true;
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox(EnumFacing side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.25f;
        bounds[0][1] = 0.75f;
        bounds[1][0] = 0.125f;
        bounds[1][1] = 0.251f;
        bounds[2][0] = 0.25f;
        bounds[2][1] = 0.75f;
        MatrixTranformations.transform(bounds, side);
        return new AxisAlignedBB((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    private void refreshRenderState() {
        this.renderState = this.station.isTaken() ? (this.station.isMainStation() ? EnumRobotStationState.Linked : EnumRobotStationState.Reserved) : EnumRobotStationState.Available;
    }

    public EnumRobotStationState getRenderState() {
        if (this.renderState == null) {
            this.renderState = EnumRobotStationState.None;
        }
        return this.renderState;
    }

    @Override
    public IPipePluggableStaticRenderer getRenderer() {
        return RobotStationRenderer.INSTANCE;
    }

    @Override
    public void writeData(ByteBuf data) {
        this.refreshRenderState();
        data.writeByte(this.getRenderState().ordinal());
    }

    @Override
    public boolean requiresRenderUpdate(PipePluggable o) {
        return this.getRenderState() != ((RobotStationPluggable)o).getRenderState();
    }

    @Override
    public void readData(ByteBuf data) {
        try {
            this.renderState = EnumRobotStationState.values()[data.readUnsignedByte()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.renderState = EnumRobotStationState.None;
        }
    }

    @Override
    public PipePluggable createPipePluggable(IPipe pipe, EnumFacing side, ItemStack stack) {
        return new RobotStationPluggable();
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.station != null && this.station.robotTaking() != null && this.station.robotTaking().getBattery() != null && this.station.robotTaking().getDockingStation() == this.station) {
            return ((EntityRobot)this.station.robotTaking()).receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        if (this.station == null) {
            left.add("RobotStationPluggable: No station found!");
        } else {
            this.refreshRenderState();
            left.add("Docking Station (side " + side.name() + ", " + this.renderState.name() + ")");
            if (this.station.robotTaking() != null && this.station.robotTaking() instanceof IDebuggable) {
                ((IDebuggable)((Object)this.station.robotTaking())).getDebugInfo(left, right, side);
            }
        }
    }

    public static enum EnumRobotStationState {
        None,
        Available,
        Reserved,
        Linked;


        public String getTextureSuffix() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

