/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.api.core.ISerializable;
import buildcraft.api.core.IZone;
import buildcraft.robotics.ZoneChunk;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;

public class ZonePlan
implements IZone,
ISerializable {
    private final HashMap<ChunkCoordIntPair, ZoneChunk> chunkMapping = new HashMap();

    public boolean get(int x, int z) {
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        ChunkCoordIntPair chunkId = new ChunkCoordIntPair(xChunk, zChunk);
        if (!this.chunkMapping.containsKey(chunkId)) {
            return false;
        }
        ZoneChunk property = this.chunkMapping.get(chunkId);
        return property.get(x & 0xF, z & 0xF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(int x, int z, boolean val) {
        ZoneChunk property;
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        ChunkCoordIntPair chunkId = new ChunkCoordIntPair(xChunk, zChunk);
        if (!this.chunkMapping.containsKey(chunkId)) {
            if (!val) return;
            property = new ZoneChunk();
            this.chunkMapping.put(chunkId, property);
        } else {
            property = this.chunkMapping.get(chunkId);
        }
        property.set(x & 0xF, z & 0xF, val);
        if (!property.isEmpty()) return;
        this.chunkMapping.remove(chunkId);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ChunkCoordIntPair, ZoneChunk> e : this.chunkMapping.entrySet()) {
            NBTTagCompound subNBT = new NBTTagCompound();
            subNBT.func_74768_a("chunkX", e.getKey().field_77276_a);
            subNBT.func_74768_a("chunkZ", e.getKey().field_77275_b);
            e.getValue().writeToNBT(subNBT);
            list.func_74742_a((NBTBase)subNBT);
        }
        nbt.func_74782_a("chunkMapping", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("chunkMapping", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound subNBT = list.func_150305_b(i);
            ChunkCoordIntPair id = new ChunkCoordIntPair(subNBT.func_74762_e("chunkX"), subNBT.func_74762_e("chunkZ"));
            ZoneChunk chunk = new ZoneChunk();
            chunk.readFromNBT(subNBT);
            this.chunkMapping.put(id, chunk);
        }
    }

    @Override
    public double distanceTo(BlockPos index) {
        return Math.sqrt(this.distanceToSquared(index));
    }

    @Override
    public double distanceToSquared(BlockPos index) {
        double maxSqrDistance = Double.MAX_VALUE;
        for (Map.Entry<ChunkCoordIntPair, ZoneChunk> e : this.chunkMapping.entrySet()) {
            double dz;
            double dx = (e.getKey().field_77276_a << 12) - index.func_177958_n();
            double sqrDistance = dx * dx + (dz = (double)((e.getKey().field_77275_b << 12) - index.func_177952_p())) * dz;
            if (!(sqrDistance < maxSqrDistance)) continue;
            maxSqrDistance = sqrDistance;
        }
        return maxSqrDistance;
    }

    @Override
    public boolean contains(Vec3 point) {
        int xBlock = (int)Math.floor(point.field_72450_a);
        int zBlock = (int)Math.floor(point.field_72449_c);
        return this.get(xBlock, zBlock);
    }

    @Override
    public BlockPos getRandomBlockPos(Random rand) {
        if (this.chunkMapping.size() == 0) {
            return null;
        }
        int chunkId = rand.nextInt(this.chunkMapping.size());
        for (Map.Entry<ChunkCoordIntPair, ZoneChunk> e : this.chunkMapping.entrySet()) {
            if (chunkId == 0) {
                BlockPos i = e.getValue().getRandomBlockPos(rand);
                int x = (e.getKey().field_77276_a << 4) + i.func_177958_n();
                int z = (e.getKey().field_77275_b << 4) + i.func_177952_p();
                return new BlockPos(x, i.func_177956_o(), z);
            }
            --chunkId;
        }
        return null;
    }

    @Override
    public void readData(ByteBuf stream) {
        this.chunkMapping.clear();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            ChunkCoordIntPair key = new ChunkCoordIntPair(stream.readInt(), stream.readInt());
            ZoneChunk value = new ZoneChunk();
            value.readData(stream);
            this.chunkMapping.put(key, value);
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeInt(this.chunkMapping.size());
        for (Map.Entry<ChunkCoordIntPair, ZoneChunk> e : this.chunkMapping.entrySet()) {
            stream.writeInt(e.getKey().field_77276_a);
            stream.writeInt(e.getKey().field_77275_b);
            e.getValue().writeData(stream);
        }
    }
}

