/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.proxy.CoreProxy;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class AIRobotBreak
extends AIRobot {
    private BlockPos blockToBreak;
    private float blockDamage = 0.0f;
    private IBlockState state;
    private float hardness;
    private float speed;

    public AIRobotBreak(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotBreak(EntityRobotBase iRobot, BlockPos iBlockToBreak) {
        this(iRobot);
        this.blockToBreak = iBlockToBreak;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.blockToBreak);
        this.robot.setItemActive(true);
        this.state = this.robot.field_70170_p.func_180495_p(this.blockToBreak);
        this.hardness = this.state.func_177230_c().func_176195_g(this.robot.field_70170_p, this.blockToBreak);
        this.speed = this.getBreakSpeed(this.robot, this.robot.func_70694_bm(), this.state, this.blockToBreak);
    }

    @Override
    public void update() {
        if (this.state == null) {
            this.state = this.robot.field_70170_p.func_180495_p(this.blockToBreak);
            if (this.state.func_177230_c().isAir((IBlockAccess)this.robot.field_70170_p, this.blockToBreak)) {
                this.setSuccess(false);
                this.terminate();
                return;
            }
            this.state = this.robot.field_70170_p.func_180495_p(this.blockToBreak);
            this.hardness = this.state.func_177230_c().func_176195_g(this.robot.field_70170_p, this.blockToBreak);
            this.speed = this.getBreakSpeed(this.robot, this.robot.func_70694_bm(), this.state, this.blockToBreak);
        }
        if (this.state.func_177230_c().isAir((IBlockAccess)this.robot.field_70170_p, this.blockToBreak) || this.hardness < 0.0f) {
            this.setSuccess(false);
            this.terminate();
            return;
        }
        this.blockDamage = this.hardness != 0.0f ? (this.blockDamage += this.speed / this.hardness / 30.0f) : 1.1f;
        if (this.blockDamage > 1.0f) {
            this.robot.field_70170_p.func_175715_c(this.robot.func_145782_y(), this.blockToBreak, -1);
            this.blockDamage = 0.0f;
            boolean continueBreaking = true;
            if (this.robot.func_70694_bm() != null && this.robot.func_70694_bm().func_77973_b().onBlockStartBreak(this.robot.func_70694_bm(), this.blockToBreak, (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.robot.field_70170_p).get())) {
                continueBreaking = false;
            }
            if (continueBreaking && BlockUtils.harvestBlock((WorldServer)this.robot.field_70170_p, this.blockToBreak, this.robot.func_70694_bm())) {
                this.robot.field_70170_p.func_180498_a(null, 2001, this.blockToBreak, Block.func_176210_f((IBlockState)this.state));
                if (this.robot.func_70694_bm() != null) {
                    this.robot.func_70694_bm().func_77973_b().func_179218_a(this.robot.func_70694_bm(), this.robot.field_70170_p, this.state.func_177230_c(), this.blockToBreak, (EntityLivingBase)this.robot);
                    if (this.robot.func_70694_bm().field_77994_a == 0) {
                        this.robot.setItemInUse(null);
                    }
                }
            } else {
                this.setSuccess(false);
            }
            this.terminate();
        } else {
            this.robot.field_70170_p.func_175715_c(this.robot.func_145782_y(), this.blockToBreak, (int)(this.blockDamage * 10.0f) - 1);
        }
    }

    @Override
    public void end() {
        this.robot.setItemActive(false);
        this.robot.field_70170_p.func_175715_c(this.robot.func_145782_y(), this.blockToBreak, -1);
    }

    private float getBreakSpeed(EntityRobotBase robot, ItemStack usingItem, IBlockState state, BlockPos pos) {
        int i;
        float f;
        ItemStack stack = usingItem;
        float f2 = f = stack == null ? 1.0f : stack.func_77973_b().getDigSpeed(stack, state);
        if (f > 1.0f && (i = EnchantmentHelper.func_77509_b((EntityLivingBase)robot)) > 0) {
            float f1 = i * i + 1;
            boolean canHarvest = ForgeHooks.canToolHarvestBlock((IBlockAccess)robot.field_70170_p, (BlockPos)pos, (ItemStack)usingItem);
            f = !canHarvest && f <= 1.0f ? (f += f1 * 0.08f) : (f += f1);
        }
        return (f = ForgeEventFactory.getBreakSpeed((EntityPlayer)BlockUtils.getFakePlayerWithTool((WorldServer)robot.field_70170_p, this.blockToBreak, robot.func_70694_bm()), (IBlockState)state, (float)f, (BlockPos)this.blockToBreak)) < 0.0f ? 0.0f : f;
    }

    @Override
    public int getEnergyCost() {
        return (int)Math.ceil(10.666666984558105);
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockToBreak != null) {
            nbt.func_74782_a("blockToBreak", NBTUtils.writeBlockPos(this.blockToBreak));
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockToBreak")) {
            this.blockToBreak = NBTUtils.readBlockPos(nbt.func_74781_a("blockToBreak"));
        }
    }
}

