/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.ai.AIRobotStraightMoveTo;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3i;

public class AIRobotGotoStation
extends AIRobot {
    private BlockPos stationIndex;
    private EnumFacing stationSide;

    public AIRobotGotoStation(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoStation(EntityRobotBase iRobot, DockingStation station) {
        this(iRobot);
        this.stationIndex = station.index();
        this.stationSide = station.side();
        this.setSuccess(false);
    }

    @Override
    public void start() {
        DockingStation station = this.robot.getRegistry().getStation(this.stationIndex, this.stationSide);
        if (station == null) {
            this.terminate();
        } else if (station == this.robot.getDockingStation()) {
            this.setSuccess(true);
            this.terminate();
        } else if (station.take(this.robot)) {
            this.startDelegateAI(new AIRobotGotoBlock(this.robot, station.getPos().func_177972_a(this.stationSide)));
        } else {
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        DockingStation station = this.robot.getRegistry().getStation(this.stationIndex, this.stationSide);
        if (station == null) {
            this.terminate();
        } else if (ai instanceof AIRobotGotoBlock) {
            if (ai.success()) {
                this.startDelegateAI(new AIRobotStraightMoveTo(this.robot, Utils.convertMiddle((Vec3i)this.stationIndex).func_178787_e(Utils.convert(this.stationSide, 0.5))));
            } else {
                this.terminate();
            }
        } else {
            this.setSuccess(true);
            if (this.stationSide.func_176740_k() != EnumFacing.Axis.Y) {
                this.robot.aimItemAt(this.stationIndex.func_177967_a(this.stationSide, 2));
            } else {
                this.robot.aimItemAt((float)MathHelper.func_76141_d((float)(this.robot.getAimYaw() / 90.0f)) * 90.0f + 180.0f, this.robot.getAimPitch());
            }
            this.robot.dock(station);
            this.terminate();
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("stationIndex", NBTUtils.writeBlockPos(this.stationIndex));
        nbt.func_74774_a("stationSide", (byte)this.stationSide.ordinal());
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        this.stationIndex = NBTUtils.readBlockPos(nbt.func_74781_a("stationIndex"));
        this.stationSide = EnumFacing.values()[nbt.func_74771_c("stationSide")];
    }
}

