/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IFluidFilter;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.IStationFilter;
import buildcraft.robotics.ai.AIRobotLoadFluids;
import buildcraft.robotics.ai.AIRobotSearchAndGotoStation;

public class AIRobotGotoStationToLoadFluids
extends AIRobot {
    private IFluidFilter filter;

    public AIRobotGotoStationToLoadFluids(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoStationToLoadFluids(EntityRobotBase iRobot, IFluidFilter iFiler) {
        this(iRobot);
        this.filter = iFiler;
    }

    @Override
    public void update() {
        this.startDelegateAI(new AIRobotSearchAndGotoStation(this.robot, new StationFilter(), this.robot.getZoneToLoadUnload()));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoStation) {
            this.setSuccess(ai.success());
            this.terminate();
        }
    }

    private class StationFilter
    implements IStationFilter {
        private StationFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            return AIRobotLoadFluids.load(AIRobotGotoStationToLoadFluids.this.robot, station, AIRobotGotoStationToLoadFluids.this.filter, false) > 0;
        }
    }
}

