/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.crops.CropManager;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.WorldServer;

public class AIRobotHarvest
extends AIRobot {
    private BlockPos blockFound;
    private int delay = 0;

    public AIRobotHarvest(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotHarvest(EntityRobotBase iRobot, BlockPos iBlockFound) {
        super(iRobot);
        this.blockFound = iBlockFound;
    }

    @Override
    public void update() {
        if (this.blockFound == null) {
            this.setSuccess(false);
            this.terminate();
            return;
        }
        if (this.delay++ > 20) {
            if (!BuildCraftAPI.getWorldProperty("harvestable").get(this.robot.field_70170_p, this.blockFound)) {
                this.setSuccess(false);
                this.terminate();
                return;
            }
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (!CropManager.harvestCrop(this.robot.field_70170_p, this.blockFound, drops)) {
                this.setSuccess(false);
                this.terminate();
                return;
            }
            for (ItemStack stack : drops) {
                BlockUtils.dropItem((WorldServer)this.robot.field_70170_p, Utils.getPos((Entity)this.robot), 6000, stack);
            }
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            nbt.func_74782_a("blockFound", NBTUtils.writeBlockPos(this.blockFound));
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.blockFound = NBTUtils.readBlockPos(nbt.func_74781_a("blockFound"));
        }
    }
}

