/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.crops.CropManager;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.WorldServer;

public class AIRobotPlant
extends AIRobot {
    private BlockPos blockFound;
    private int delay = 0;

    public AIRobotPlant(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotPlant(EntityRobotBase iRobot, BlockPos iBlockFound) {
        this(iRobot);
        this.blockFound = iBlockFound;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.blockFound);
        this.robot.setItemActive(true);
    }

    @Override
    public void update() {
        if (this.blockFound == null) {
            this.setSuccess(false);
            this.terminate();
        }
        if (this.delay++ > 40) {
            EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.robot.field_70170_p).get();
            if (!CropManager.plantCrop(this.robot.field_70170_p, player, this.robot.func_70694_bm(), this.blockFound)) {
                this.setSuccess(false);
            }
            if (this.robot.func_70694_bm().field_77994_a > 0) {
                BlockUtils.dropItem((WorldServer)this.robot.field_70170_p, Utils.getPos((Entity)this.robot), 6000, this.robot.func_70694_bm());
            }
            this.robot.setItemInUse(null);
            this.terminate();
        }
    }

    @Override
    public void end() {
        this.robot.setItemActive(false);
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            nbt.func_74782_a("blockFound", NBTUtils.writeBlockPos(this.blockFound));
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.blockFound = NBTUtils.readBlockPos(nbt.func_74781_a("blockFound"));
        }
    }
}

