/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.Utils;
import buildcraft.robotics.ai.AIRobotGoto;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public class AIRobotStraightMoveTo
extends AIRobotGoto {
    private double prevDistance = Double.MAX_VALUE;
    private Vec3 pos;

    public AIRobotStraightMoveTo(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotStraightMoveTo(EntityRobotBase iRobot, Vec3 pos) {
        this(iRobot);
        this.pos = pos;
        this.robot.aimItemAt(Utils.convertFloor(pos));
    }

    @Override
    public void start() {
        this.robot.undock();
        this.setDestination(this.robot, this.pos);
    }

    @Override
    public void update() {
        double distance = Utils.getVec((Entity)this.robot).func_72438_d(this.next);
        if (distance < this.prevDistance) {
            this.prevDistance = distance;
        } else {
            this.robot.field_70159_w = 0.0;
            this.robot.field_70181_x = 0.0;
            this.robot.field_70179_y = 0.0;
            this.robot.field_70165_t = this.pos.field_72450_a;
            this.robot.field_70163_u = this.pos.field_72448_b;
            this.robot.field_70161_v = this.pos.field_72449_c;
            this.terminate();
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        nbt.func_74776_a("x", (float)this.pos.field_72450_a);
        nbt.func_74776_a("y", (float)this.pos.field_72448_b);
        nbt.func_74776_a("z", (float)this.pos.field_72449_c);
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("x")) {
            float x = nbt.func_74760_g("x");
            float y = nbt.func_74760_g("y");
            float z = nbt.func_74760_g("z");
            this.pos = new Vec3((double)x, (double)y, (double)z);
        }
    }
}

