/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;

public class AIRobotUseToolOnBlock
extends AIRobot {
    private BlockPos useToBlock;
    private int useCycles = 0;

    public AIRobotUseToolOnBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotUseToolOnBlock(EntityRobotBase iRobot, BlockPos index) {
        this(iRobot);
        this.useToBlock = index;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.useToBlock);
        this.robot.setItemActive(true);
    }

    @Override
    public void update() {
        ++this.useCycles;
        if (this.useCycles > 40) {
            ItemStack stack = this.robot.func_70694_bm();
            EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.robot.field_70170_p).get();
            if (BlockUtils.useItemOnBlock(this.robot.field_70170_p, player, stack, this.useToBlock, EnumFacing.UP)) {
                if (this.robot.func_70694_bm().func_77984_f()) {
                    this.robot.func_70694_bm().func_77972_a(1, (EntityLivingBase)this.robot);
                    if (this.robot.func_70694_bm().func_77952_i() >= this.robot.func_70694_bm().func_77958_k()) {
                        this.robot.setItemInUse(null);
                    }
                } else {
                    this.robot.setItemInUse(null);
                }
            } else {
                this.setSuccess(false);
                if (!this.robot.func_70694_bm().func_77984_f()) {
                    BlockUtils.dropItem((WorldServer)this.robot.field_70170_p, Utils.getPos((Entity)this.robot), 6000, stack);
                    this.robot.setItemInUse(null);
                }
            }
            this.terminate();
        }
    }

    @Override
    public void end() {
        this.robot.setItemActive(false);
    }

    @Override
    public int getEnergyCost() {
        return 8;
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.useToBlock != null) {
            nbt.func_74782_a("blockFound", NBTUtils.writeBlockPos(this.useToBlock));
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.useToBlock = NBTUtils.readBlockPos(nbt.func_74781_a("blockFound"));
        }
    }
}

