/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.IFluidFilter;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotGotoStationAndLoadFluids;
import buildcraft.robotics.ai.AIRobotGotoStationAndUnloadFluids;
import buildcraft.robotics.boards.BCBoardNBT;
import buildcraft.robotics.statements.ActionRobotFilter;
import net.minecraftforge.fluids.FluidStack;

public class BoardRobotFluidCarrier
extends RedstoneBoardRobot {
    public BoardRobotFluidCarrier(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("fluidCarrier");
    }

    @Override
    public void update() {
        if (!this.robotHasFluid()) {
            IFluidFilter filter = ActionRobotFilter.getGateFluidFilter(this.robot.getLinkedStation());
            this.startDelegateAI(new AIRobotGotoStationAndLoadFluids(this.robot, filter));
        } else {
            this.startDelegateAI(new AIRobotGotoStationAndUnloadFluids(this.robot));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationAndLoadFluids) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotGotoStationAndUnloadFluids && !ai.success()) {
            this.startDelegateAI(new AIRobotGotoSleep(this.robot));
        }
    }

    private boolean robotHasFluid() {
        FluidStack tank = this.robot.getTankInfo(null)[0].fluid;
        return tank != null && tank.amount > 0;
    }
}

