/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceIdBlock;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.api.statements.StatementSlot;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotSearchAndGotoBlock;
import buildcraft.robotics.statements.ActionRobotFilter;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public abstract class BoardRobotGenericSearchBlock
extends RedstoneBoardRobot {
    private BlockPos blockFound;
    private ArrayList<IBlockState> blockFilter = new ArrayList();

    public BoardRobotGenericSearchBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public abstract boolean isExpectedBlock(World var1, BlockPos var2);

    @Override
    public void update() {
        this.updateFilter();
        this.startDelegateAI(new AIRobotSearchAndGotoBlock(this.robot, false, new IBlockFilter(){

            @Override
            public boolean matches(World world, BlockPos pos) {
                if (BoardRobotGenericSearchBlock.this.isExpectedBlock(world, pos) && !BoardRobotGenericSearchBlock.this.robot.getRegistry().isTaken(new ResourceIdBlock(pos))) {
                    return BoardRobotGenericSearchBlock.this.matchesGateFilter(world, pos);
                }
                return false;
            }
        }));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoBlock) {
            if (ai.success()) {
                this.blockFound = ((AIRobotSearchAndGotoBlock)ai).getBlockFound();
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        }
    }

    @Override
    public void end() {
        this.releaseBlockFound(true);
    }

    protected BlockPos blockFound() {
        return this.blockFound;
    }

    protected void releaseBlockFound(boolean success) {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    public final void updateFilter() {
        this.blockFilter.clear();
        for (StatementSlot slot : this.robot.getLinkedStation().getActiveActions()) {
            if (!(slot.statement instanceof ActionRobotFilter)) continue;
            for (IStatementParameter p : slot.parameters) {
                StatementParameterItemStack param;
                ItemStack stack;
                if (p == null || !(p instanceof StatementParameterItemStack) || (stack = (param = (StatementParameterItemStack)p).getItemStack()) == null || !(stack.func_77973_b() instanceof ItemBlock)) continue;
                ItemBlock item = (ItemBlock)stack.func_77973_b();
                this.blockFilter.add(item.field_150939_a.func_176203_a(stack.func_77960_j()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matchesGateFilter(World world, BlockPos pos) {
        IBlockState state;
        if (this.blockFilter.size() == 0) {
            return true;
        }
        World world2 = world;
        synchronized (world2) {
            state = world.func_180495_p(pos);
        }
        for (IBlockState filter : this.blockFilter) {
            if (filter != state) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            nbt.func_74782_a("indexStored", NBTUtils.writeBlockPos(this.blockFound));
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("indexStored")) {
            this.blockFound = NBTUtils.readBlockPos(nbt.func_74781_a("indexStored"));
        }
    }
}

