/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.IStackFilter;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.IEntityFilter;
import buildcraft.robotics.ai.AIRobotAttack;
import buildcraft.robotics.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotSearchEntity;
import buildcraft.robotics.boards.BCBoardNBT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;

public class BoardRobotKnight
extends RedstoneBoardRobot {
    public BoardRobotKnight(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("knight");
    }

    @Override
    public final void update() {
        if (this.robot.func_70694_bm() == null) {
            this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, new IStackFilter(){

                @Override
                public boolean matches(ItemStack stack) {
                    return stack.func_77973_b() instanceof ItemSword;
                }
            }));
        } else {
            this.startDelegateAI(new AIRobotSearchEntity(this.robot, new IEntityFilter(){

                @Override
                public boolean matches(Entity entity) {
                    return entity instanceof IMob || entity instanceof EntityWolf && ((EntityWolf)entity).func_70919_bu();
                }
            }, 250.0f, this.robot.getZoneToWork()));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotFetchAndEquipItemStack) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotSearchEntity) {
            if (ai.success()) {
                this.startDelegateAI(new AIRobotAttack(this.robot, ((AIRobotSearchEntity)ai).target));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        }
    }
}

