/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.render;

import buildcraft.BuildCraftCore;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.pluggable.IPipePluggableState;
import buildcraft.api.transport.pluggable.IPipePluggableStaticRenderer;
import buildcraft.api.transport.pluggable.IPipeRenderState;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.render.BakedModelHolder;
import buildcraft.core.lib.render.BuildCraftBakedModel;
import buildcraft.core.lib.utils.MatrixUtils;
import buildcraft.robotics.RobotStationPluggable;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RobotStationRenderer
extends BakedModelHolder
implements IPipePluggableStaticRenderer {
    public static final RobotStationRenderer INSTANCE = new RobotStationRenderer();
    private static final ResourceLocation baseLoc = new ResourceLocation("buildcraftrobotics:models/pluggables/robot_station_base.obj");
    private TextureAtlasSprite baseSprite;
    private final Map<RobotStationPluggable.EnumRobotStationState, TextureAtlasSprite> stateSprites = Maps.newEnumMap(RobotStationPluggable.EnumRobotStationState.class);
    private final Map<RobotStationPluggable.EnumRobotStationState, List<BakedQuad>> stateQuads = Maps.newEnumMap(RobotStationPluggable.EnumRobotStationState.class);

    private IModel modelBase() {
        return this.getModelOBJ(baseLoc);
    }

    @SubscribeEvent
    public void textureStitchPre(TextureStitchEvent.Pre pre) {
        TextureMap map = pre.map;
        this.baseSprite = null;
        this.baseSprite = map.getTextureExtry("buildcraftrobotics:station/base");
        if (this.baseSprite == null) {
            this.baseSprite = map.func_174942_a(new ResourceLocation("buildcraftrobotics:station/base"));
        }
        for (RobotStationPluggable.EnumRobotStationState state : RobotStationPluggable.EnumRobotStationState.values()) {
            String suffix = state.getTextureSuffix() + (BuildCraftCore.colorBlindMode ? "_cb" : "");
            ResourceLocation location = new ResourceLocation("buildcraftrobotics:station/state_" + suffix);
            TextureAtlasSprite sprite = map.getTextureExtry(location.toString());
            if (sprite == null) {
                sprite = map.func_174942_a(location);
            }
            this.stateSprites.put(state, sprite);
        }
    }

    @SubscribeEvent
    public void textureStitchPost(TextureStitchEvent.Post post) {
        for (RobotStationPluggable.EnumRobotStationState state : RobotStationPluggable.EnumRobotStationState.values()) {
            Matrix4f translation = new Matrix4f();
            translation.setIdentity();
            translation.setTranslation(new Vector3f(0.175f, 0.0f, 0.0f));
            ArrayList quads = Lists.newArrayList();
            for (BakedQuad quad : BuildCraftBakedModel.createModelItemLayer(this.stateSprites.get((Object)state)).func_177550_a()) {
                quad = RobotStationRenderer.transform(quad, translation);
                quad = RobotStationRenderer.replaceTint(quad, 0xFFFFFF);
                quads.add(quad);
            }
            this.stateQuads.put(state, quads);
        }
    }

    @Override
    public List<BakedQuad> bakeCutout(IPipeRenderState render, IPipePluggableState pluggableState, IPipe pipe, PipePluggable pluggable, EnumFacing face) {
        RobotStationPluggable station = (RobotStationPluggable)pluggable;
        final TextureAtlasSprite baseSprite = this.baseSprite;
        IModel base = this.modelBase();
        List<BakedQuad> stateQuads = this.stateQuads.get((Object)station.getRenderState());
        ArrayList quads = Lists.newArrayList();
        if (base != null) {
            Matrix4f matrix = MatrixUtils.rotateTowardsFace(face);
            IFlexibleBakedModel baked = base.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176600_a, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                public TextureAtlasSprite apply(ResourceLocation input) {
                    return baseSprite;
                }
            });
            for (BakedQuad quad : baked.func_177550_a()) {
                quad = RobotStationRenderer.transform(quad, matrix);
                quad = RobotStationRenderer.replaceShade(quad, -1);
                quad = RobotStationRenderer.applyDiffuse(quad);
                quads.add(quad);
            }
            if (stateQuads != null) {
                for (BakedQuad quad : stateQuads) {
                    quad = RobotStationRenderer.transform(quad, matrix);
                    quad = RobotStationRenderer.applyDiffuse(quad);
                    quads.add(quad);
                }
            }
        }
        return quads;
    }
}

