/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.statements;

import buildcraft.api.robots.DockingStation;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.robotics.RobotUtils;
import java.util.List;

public class TriggerRobotLinked
extends BCStatement
implements ITriggerInternal {
    private final boolean reserved;

    public TriggerRobotLinked(boolean reserved) {
        super("buildcraft:robot." + (reserved ? "reserved" : "linked"));
        this.setBuildCraftLocation("robotics", "triggers/trigger_robot_" + (reserved ? "reserved" : "linked"));
        this.reserved = reserved;
    }

    @Override
    public String getDescription() {
        return BCStringUtils.localize("gate.trigger.robot." + (this.reserved ? "reserved" : "linked"));
    }

    @Override
    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        List<DockingStation> stations = RobotUtils.getStations(container.getTile());
        for (DockingStation station : stations) {
            if (!station.isTaken() || !this.reserved && !station.isMainStation()) continue;
            return true;
        }
        return false;
    }
}

