/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.blocks.IColorRemovable;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.events.PipePlacedEvent;
import buildcraft.api.items.IMapLocation;
import buildcraft.api.properties.BuildCraftExtendedProperty;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.ICustomPipeConnection;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import buildcraft.api.transport.pluggable.IPipePluggableItem;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.BCRegistry;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.render.ICustomHighlight;
import buildcraft.core.lib.utils.ICustomStateMapper;
import buildcraft.core.lib.utils.IdentifiableAABB;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Gate;
import buildcraft.transport.ISolidSideTile;
import buildcraft.transport.ItemGateCopier;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipePluggableState;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.gates.GatePluggable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGenericPipe
extends BlockBuildCraft
implements IColorRemovable,
ICustomHighlight,
ICustomStateMapper,
ICustomPipeConnection {
    public static final BuildCraftExtendedProperty<TileGenericPipe.CoreState> PIPE_CORE_STATE = BuildCraftExtendedProperty.createExtended("core_state", TileGenericPipe.CoreState.class);
    public static final BuildCraftExtendedProperty<PipeRenderState> PIPE_RENDER_STATE = BuildCraftExtendedProperty.createExtended("render_state", PipeRenderState.class);
    public static final BuildCraftExtendedProperty<PipePluggableState> PIPE_PLUGGABLE_STATE = BuildCraftExtendedProperty.createExtended("pluggable_state", PipePluggableState.class);
    public static final BuildCraftExtendedProperty<Pipe<?>> PIPE_PIPE = BuildCraftExtendedProperty.createExtended("pipe_pipe", Pipe.class);
    public static Map<ItemPipe, Class<? extends Pipe<?>>> pipes = Maps.newHashMap();
    public static Map<BlockPos, Pipe<?>> pipeRemoved = Maps.newHashMap();
    private static long lastRemovedDate = -1L;
    private static final EnumFacing[] DIR_VALUES = EnumFacing.values();

    public BlockGenericPipe() {
        super(Material.field_151592_s, (BCCreativeTab)null, true, GENERIC_PIPE_DATA, CONNECTED_UP, CONNECTED_DOWN, CONNECTED_EAST, CONNECTED_WEST, CONNECTED_NORTH, CONNECTED_SOUTH, PIPE_CORE_STATE, PIPE_RENDER_STATE, PIPE_PLUGGABLE_STATE, PIPE_PIPE);
        this.func_149647_a(null);
        this.func_149713_g(0);
    }

    public float func_176195_g(World par1World, BlockPos pos) {
        return BuildCraftTransport.pipeDurability;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return layer == this.func_180664_k() || layer == EnumWorldBlockLayer.TRANSLUCENT;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)GENERIC_PIPE_DATA);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)GENERIC_PIPE_DATA, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return tintIndex;
    }

    @Override
    public double getExpansion() {
        return 0.0;
    }

    @Override
    public double getBreathingCoefficent() {
        return 0.0;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISolidSideTile) {
            return ((ISolidSideTile)tile).isSolidOnSide(side);
        }
        return false;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        state = super.func_176221_a(state, access, pos);
        TileEntity tile = access.func_175625_s(pos);
        if (tile == null | !(tile instanceof TileGenericPipe)) {
            return state;
        }
        TileGenericPipe pipe = (TileGenericPipe)tile;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            boolean hasPipe = pipe.isPipeConnected(face);
            state = state.func_177226_a((IProperty)CONNECTED_MAP.get(face), (Comparable)Boolean.valueOf(hasPipe));
        }
        return state;
    }

    public IExtendedBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extended = (IExtendedBlockState)super.func_176221_a(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof TileGenericPipe)) {
            return extended;
        }
        TileGenericPipe pipe = (TileGenericPipe)tile;
        extended = extended.withProperty(PIPE_CORE_STATE.asUnlistedProperty(), (Object)pipe.coreState);
        extended = extended.withProperty(PIPE_RENDER_STATE.asUnlistedProperty(), (Object)pipe.renderState);
        extended = extended.withProperty(PIPE_PLUGGABLE_STATE.asUnlistedProperty(), (Object)pipe.pluggableState);
        extended = extended.withProperty(PIPE_PIPE.asUnlistedProperty(), pipe.pipe);
        return extended;
    }

    public boolean func_149721_r() {
        return false;
    }

    @Override
    public AxisAlignedBB[] getBoxes(IBlockAccess access, BlockPos pos, IBlockState state) {
        ArrayList bbs = Lists.newArrayList();
        float min = 0.25f;
        float max = 0.75f;
        IdentifiableAABB<Part> base = new IdentifiableAABB<Part>(this.getPipeBoundingBox(null), Part.Pipe);
        bbs.add(base);
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TileGenericPipe) {
            TileGenericPipe pipe = (TileGenericPipe)tile;
            for (EnumFacing face : EnumFacing.values()) {
                if (!pipe.isPipeConnected(face)) continue;
                bbs.add(new IdentifiableAABB<Part>(this.getPipeBoundingBox(face), Part.Pipe));
            }
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (!pipe.hasPipePluggable(face)) continue;
                bbs.add(new IdentifiableAABB<Part>(pipe.getPipePluggable(face).getBoundingBox(face), Part.Pluggable));
            }
        }
        return bbs.toArray(new IdentifiableAABB[bbs.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, pos, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (rayTraceResult != null && rayTraceResult.boundingBox != null) {
            AxisAlignedBB box = rayTraceResult.boundingBox;
            switch (rayTraceResult.hitPart) {
                case Pluggable: {
                    float scale = 0.001f;
                    box = box.func_72314_b((double)scale, (double)scale, (double)scale);
                    break;
                }
                case Pipe: {
                    float scale = 0.08f;
                    box = box.func_72314_b((double)scale, (double)scale, (double)scale);
                    break;
                }
                case Wire: {
                    break;
                }
            }
            return box.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
        return super.func_180646_a(world, pos).func_72314_b((double)-0.85f, (double)-0.85f, (double)-0.85f);
    }

    @Override
    public MovingObjectPosition func_180636_a(World world, BlockPos pos, Vec3 origin, Vec3 direction) {
        RaytraceResult raytraceResult = this.doRayTrace(world, pos, origin, direction);
        if (raytraceResult == null) {
            return null;
        }
        return raytraceResult.movingObjectPosition;
    }

    public RaytraceResult doRayTrace(World world, BlockPos pos, EntityPlayer player) {
        double reachDistance = 5.0;
        if (player instanceof EntityPlayerMP) {
            reachDistance = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        double eyeHeight = player.func_70047_e();
        Vec3 lookVec = player.func_70040_Z();
        Vec3 origin = new Vec3(player.field_70165_t, player.field_70163_u + eyeHeight, player.field_70161_v);
        Vec3 direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        return this.doRayTrace(world, pos, origin, direction);
    }

    public RaytraceResult doRayTrace(World world, BlockPos pos, Vec3 origin, Vec3 direction) {
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (!BlockGenericPipe.isValid(pipe)) {
            return null;
        }
        TileGenericPipe tileG = pipe.container;
        if (tileG == null) {
            return null;
        }
        TraceTester tester = new TraceTester(world, pos, origin, direction);
        tester.test(this.getPipeBoundingBox(null), null);
        for (EnumFacing face : EnumFacing.values()) {
            if (!tileG.isPipeConnected(face)) continue;
            tester.test(this.getPipeBoundingBox(face), face);
        }
        for (EnumFacing face : EnumFacing.values()) {
            if (tileG.getPipePluggable(face) == null) continue;
            AxisAlignedBB aabb = tileG.getPipePluggable(face).getBoundingBox(face);
            IdentifiableAABB<Part> iaabb = new IdentifiableAABB<Part>(aabb, Part.Pluggable);
            tester.test(iaabb, face);
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (tester.closestHit != null) {
            return new RaytraceResult(tester.closestHit, tester.closestBox, tester.closestSide, tester.closestSideHit);
        }
        return null;
    }

    private void setBlockBounds(AxisAlignedBB bb) {
        this.func_149676_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
    }

    private IdentifiableAABB<Part> getPipeBoundingBox(EnumFacing side) {
        float min = 0.25f;
        float max = 0.75f;
        if (side == null) {
            return new IdentifiableAABB<Part>(min, min, min, max, max, max, Part.Pipe);
        }
        float[][] bounds = new float[3][2];
        bounds[0][0] = min;
        bounds[0][1] = max;
        bounds[1][0] = 0.0f;
        bounds[1][1] = min;
        bounds[2][0] = min;
        bounds[2][1] = max;
        MatrixTranformations.transform(bounds, side);
        return new IdentifiableAABB<Part>(bounds[0][0], bounds[1][0], bounds[2][0], bounds[0][1], bounds[1][1], bounds[2][1], Part.Pipe);
    }

    public static void removePipe(Pipe<?> pipe) {
        if (!BlockGenericPipe.isValid(pipe)) {
            return;
        }
        World world = pipe.container.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = pipe.container.func_174877_v();
        if (lastRemovedDate != world.func_82737_E()) {
            lastRemovedDate = world.func_82737_E();
            pipeRemoved.clear();
        }
        pipeRemoved.put(pos, pipe);
        for (EnumFacing dir : EnumFacing.values()) {
            TileEntity tile = world.func_175625_s(pos.func_177972_a(dir));
            if (!(tile instanceof IPipeTile)) continue;
            Pipe tpipe = (Pipe)((IPipeTile)tile).getPipe();
            tpipe.scheduleWireUpdate();
        }
        world.func_175713_t(pos);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Utils.preDestroyBlock(world, pos);
        BlockGenericPipe.removePipe(BlockGenericPipe.getPipe((IBlockAccess)world, pos));
        super.func_180663_b(world, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Pipe<?> pipe = BlockGenericPipe.getPipe(world, pos);
        if (pipe == null) {
            pipe = pipeRemoved.get(new BlockPos((Vec3i)pos));
        }
        if (pipe != null && pipe.item != null) {
            list.add(new ItemStack(pipe.item, 1, pipe.container.getItemMetadata()));
            list.addAll(pipe.computeItemDrop());
            list.addAll(pipe.getDroppedItems());
        }
        return list;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileGenericPipe();
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float f, int dmg) {
        Item k1;
        if (world.field_72995_K) {
            return;
        }
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (pipe == null) {
            pipe = pipeRemoved.get(new BlockPos((Vec3i)pos));
        }
        if (pipe != null && (k1 = pipe.item) != null) {
            pipe.dropContents();
            for (ItemStack is : pipe.computeItemDrop()) {
                BlockGenericPipe.func_180635_a((World)world, (BlockPos)pos, (ItemStack)is);
            }
            BlockGenericPipe.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(k1, 1, pipe.container.getItemMetadata()));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int dmg) {
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        EntityPlayer clientPlayer = CoreProxy.proxy.getClientPlayer();
        if (clientPlayer != null) {
            return this.getPickBlock(target, world, pos, clientPlayer);
        }
        return new ItemStack(BlockGenericPipe.getPipe((IBlockAccess)world, (BlockPos)pos).item, 1, BlockGenericPipe.getPipe((IBlockAccess)world, (BlockPos)pos).container.getItemMetadata());
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, pos, player);
        if (rayTraceResult != null && rayTraceResult.boundingBox != null) {
            switch (rayTraceResult.hitPart) {
                case Pluggable: {
                    Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, pos);
                    PipePluggable pluggable = pipe.container.getPipePluggable(rayTraceResult.sideHit);
                    ItemStack[] drops = pluggable.getDropItems(pipe.container);
                    if (drops != null && drops.length > 0) {
                        return drops[0];
                    }
                }
                case Pipe: {
                    return new ItemStack(BlockGenericPipe.getPipe((IBlockAccess)world, (BlockPos)pos).item, 1, BlockGenericPipe.getPipe((IBlockAccess)world, (BlockPos)pos).container.getItemMetadata());
                }
            }
        }
        return null;
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighbour) {
        super.func_176204_a(world, pos, state, neighbour);
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.container.scheduleNeighborChange();
            pipe.container.redstoneInput = 0;
            for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                EnumFacing d = EnumFacing.field_82609_l[i];
                pipe.container.redstoneInputSide[i] = this.getRedstoneInputToPipe(world, pos, d);
                if (pipe.container.redstoneInput >= pipe.container.redstoneInputSide[i]) continue;
                pipe.container.redstoneInput = pipe.container.redstoneInputSide[i];
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileGenericPipe) {
            for (EnumFacing face : EnumFacing.values()) {
                if (!pos.func_177972_a(face).equals((Object)neighbor)) continue;
                ((TileGenericPipe)tile).scheduleNeighborChange(EnumPipePart.fromFacing(face));
                return;
            }
        }
    }

    private int getRedstoneInputToPipe(World world, BlockPos pos, EnumFacing d) {
        return world.func_175651_c(pos.func_177972_a(d), d);
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int meta, EntityLivingBase entity) {
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onBlockPlaced();
        }
        return this.func_176223_P();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onBlockPlacedBy(placer);
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        if (super.func_180639_a(world, pos, state, player, side, xOffset, yOffset, zOffset)) {
            return true;
        }
        world.func_180496_d(pos, (Block)BuildCraftTransport.genericPipeBlock);
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, pos);
        RaytraceResult rayTrace = this.doRayTrace(world, pos, player);
        if (rayTrace != null) {
            side = rayTrace.sideHit;
        }
        if (BlockGenericPipe.isValid(pipe)) {
            ItemStack currentItem = player.func_71045_bC();
            if (player.func_70093_af() && currentItem == null) {
                if (this.stripEquipment(world, pos, player, pipe, side)) {
                    return true;
                }
            } else if (currentItem != null) {
                if (currentItem.func_77973_b() == Items.field_151155_ap) {
                    return false;
                }
                if (currentItem.func_77973_b() instanceof ItemPipe) {
                    return false;
                }
                if (currentItem.func_77973_b() instanceof ItemGateCopier) {
                    return false;
                }
                if (currentItem.func_77973_b() instanceof IToolWrench) {
                    RaytraceResult rayTraceResult = this.doRayTrace(world, pos, player);
                    if (rayTraceResult != null) {
                        EnumFacing hitSide = rayTraceResult.hitPart == Part.Pipe ? rayTraceResult.sideHit : null;
                        return pipe.blockActivated(player, hitSide);
                    }
                    return pipe.blockActivated(player, null);
                }
                if (currentItem.func_77973_b() instanceof IMapLocation) {
                    return false;
                }
                if (PipeWire.RED.isPipeWire(currentItem)) {
                    if (this.addOrStripWire(player, pipe, PipeWire.RED)) {
                        return true;
                    }
                } else if (PipeWire.BLUE.isPipeWire(currentItem)) {
                    if (this.addOrStripWire(player, pipe, PipeWire.BLUE)) {
                        return true;
                    }
                } else if (PipeWire.GREEN.isPipeWire(currentItem)) {
                    if (this.addOrStripWire(player, pipe, PipeWire.GREEN)) {
                        return true;
                    }
                } else if (PipeWire.YELLOW.isPipeWire(currentItem)) {
                    if (this.addOrStripWire(player, pipe, PipeWire.YELLOW)) {
                        return true;
                    }
                } else {
                    if (currentItem.func_77973_b() == Items.field_151131_as) {
                        if (!world.field_72995_K) {
                            pipe.container.setPipeColor(-1);
                        }
                        return true;
                    }
                    if (currentItem.func_77973_b() instanceof IPipePluggableItem && this.addOrStripPipePluggable(world, pos, currentItem, player, side, pipe)) {
                        return true;
                    }
                }
            }
            Gate clickedGate = null;
            if (rayTrace != null && rayTrace.hitPart == Part.Pluggable && pipe.container.getPipePluggable(rayTrace.sideHit) instanceof GatePluggable) {
                clickedGate = pipe.gates[rayTrace.sideHit.ordinal()];
            }
            if (clickedGate != null) {
                clickedGate.openGui(player);
                return true;
            }
            if (pipe.blockActivated(player, side)) {
                return true;
            }
            if (rayTrace != null) {
                EnumFacing hitSide = rayTrace.hitPart == Part.Pipe ? rayTrace.sideHit : null;
                return pipe.blockActivated(player, hitSide);
            }
        }
        return false;
    }

    private boolean addOrStripPipePluggable(World world, BlockPos pos, ItemStack stack, EntityPlayer player, EnumFacing side, Pipe<?> pipe) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, pos, player);
        EnumFacing placementSide = rayTraceResult != null && rayTraceResult.sideHit != null ? rayTraceResult.sideHit : side;
        IPipePluggableItem pluggableItem = (IPipePluggableItem)stack.func_77973_b();
        PipePluggable pluggable = pluggableItem.createPipePluggable(pipe, placementSide, stack);
        if (pluggable == null) {
            return false;
        }
        if (player.func_70093_af() && pipe.container.hasPipePluggable(side) && rayTraceResult != null && rayTraceResult.hitPart == Part.Pluggable && pluggable.getClass().isInstance(pipe.container.getPipePluggable(side))) {
            return pipe.container.setPluggable(side, null, player);
        }
        if (rayTraceResult != null && rayTraceResult.hitPart == Part.Pipe && !pipe.container.hasPipePluggable(placementSide)) {
            if (pipe.container.setPluggable(placementSide, pluggable, player)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean addOrStripWire(EntityPlayer player, Pipe<?> pipe, PipeWire color) {
        if (this.addWire(pipe, color)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_71045_bC().func_77979_a(1);
            }
            return true;
        }
        return player.func_70093_af() && this.stripWire(pipe, color, player);
    }

    private boolean addWire(Pipe<?> pipe, PipeWire color) {
        if (!pipe.wireSet[color.ordinal()]) {
            pipe.wireSet[color.ordinal()] = true;
            pipe.signalStrength[color.ordinal()] = 0;
            pipe.updateSignalState();
            pipe.container.scheduleRenderUpdate();
            return true;
        }
        return false;
    }

    private boolean stripWire(Pipe<?> pipe, PipeWire color, EntityPlayer player) {
        if (pipe.wireSet[color.ordinal()]) {
            if (!pipe.container.func_145831_w().field_72995_K) {
                this.dropWire(color, pipe, player);
            }
            pipe.signalStrength[color.ordinal()] = 0;
            pipe.wireSet[color.ordinal()] = false;
            if (!pipe.container.func_145831_w().field_72995_K) {
                pipe.propagateSignalState(color, 0);
                if (BlockGenericPipe.isFullyDefined(pipe)) {
                    pipe.resolveActions();
                }
            }
            pipe.container.scheduleRenderUpdate();
            return true;
        }
        return false;
    }

    private boolean stripEquipment(World world, BlockPos pos, EntityPlayer player, Pipe<?> pipe, EnumFacing side) {
        if (!world.field_72995_K) {
            EnumFacing nSide = side;
            RaytraceResult rayTraceResult = this.doRayTrace(world, pos, player);
            if (rayTraceResult != null && rayTraceResult.hitPart != Part.Pipe) {
                nSide = rayTraceResult.sideHit;
            }
            if (pipe.container.hasPipePluggable(nSide)) {
                return pipe.container.setPluggable(nSide, null, player);
            }
            for (PipeWire color : PipeWire.values()) {
                if (!this.stripWire(pipe, color, player)) continue;
                return true;
            }
        }
        return false;
    }

    private void dropWire(PipeWire pipeWire, Pipe<?> pipe, EntityPlayer player) {
        Utils.dropTryIntoPlayerInventory(pipe.container.func_145831_w(), pipe.container.func_174877_v(), pipeWire.getStack(), player);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        super.func_176199_a(world, pos, entity);
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onEntityCollidedWithBlock(entity);
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
        Pipe<?> pipe = BlockGenericPipe.getPipe(world, pos);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.canConnectRedstone();
        }
        return false;
    }

    public int func_176211_b(IBlockAccess iblockaccess, BlockPos pos, IBlockState state, EnumFacing l) {
        Pipe<?> pipe = BlockGenericPipe.getPipe(iblockaccess, pos);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.isPoweringTo(l);
        }
        return 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_180656_a(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing l) {
        Pipe<?> pipe = BlockGenericPipe.getPipe(world, pos);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.isIndirectlyPoweringTo(l);
        }
        return 0;
    }

    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random random) {
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, pos);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.randomDisplayTick(random);
        }
    }

    public static ItemPipe registerPipe(Class<? extends Pipe<?>> clas, BCCreativeTab creativeTab) {
        ItemPipe item = new ItemPipe(creativeTab);
        item.func_77655_b("buildcraftPipe." + clas.getSimpleName().toLowerCase(Locale.ENGLISH));
        BCRegistry.INSTANCE.registerItem(item, true);
        pipes.put(item, clas);
        Pipe<?> dummyPipe = BlockGenericPipe.createPipe(item);
        if (dummyPipe != null) {
            item.setPipeIconIndex(dummyPipe.getIconIndexForItem());
            TransportProxy.proxy.setIconProviderFromPipe(item, dummyPipe);
        }
        return item;
    }

    public static Pipe<?> createPipe(ItemPipe key) {
        try {
            Class<Pipe<?>> pipe = pipes.get(key);
            if (pipe != null) {
                return pipe.getConstructor(Item.class).newInstance(key);
            }
            BCLog.logger.warn("Detected pipe with unknown key (" + key + "). Did you remove a buildcraft addon?");
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.warn("Failed to create pipe with (" + key + "). No valid constructor found. Possibly a item ID conflit.");
        }
        return null;
    }

    public static boolean placePipe(Pipe<?> pipe, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side) {
        TileEntity tile;
        boolean placed;
        if (world.field_72995_K) {
            return true;
        }
        if (player != null) {
            IBlockState stateAgainst = world.func_180495_p(pos.func_177972_a(side.func_176734_d()));
            BlockEvent.PlaceEvent placeEvent = new BlockEvent.PlaceEvent(new BlockSnapshot(world, pos, state), stateAgainst, player);
            MinecraftForge.EVENT_BUS.post((Event)placeEvent);
            if (placeEvent.isCanceled()) {
                return false;
            }
        }
        if ((placed = world.func_180501_a(pos, state, 3)) && (tile = world.func_175625_s(pos)) instanceof TileGenericPipe) {
            TileGenericPipe tilePipe = (TileGenericPipe)tile;
            tilePipe.initialize(pipe);
            tilePipe.sendNetworkUpdate();
            MinecraftForge.EVENT_BUS.post((Event)new PipePlacedEvent(player, pipe.item.func_77658_a(), pos));
        }
        return placed;
    }

    public static Pipe<?> getPipe(IBlockAccess blockAccess, BlockPos pos) {
        IPipe pipe;
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile instanceof IPipeTile && !tile.func_145837_r() && (pipe = ((IPipeTile)tile).getPipe()) instanceof Pipe) {
            return (Pipe)pipe;
        }
        return null;
    }

    public static boolean isFullyDefined(Pipe<?> pipe) {
        return pipe != null && pipe.transport != null && pipe.container != null;
    }

    public static boolean isValid(Pipe<?> pipe) {
        return BlockGenericPipe.isFullyDefined(pipe);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)worldObj, target.func_178782_a());
        if (pipe == null) {
            return false;
        }
        TextureAtlasSprite icon = pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        EnumFacing sideHit = target.field_178784_b;
        BlockGenericPipe block = BuildCraftTransport.genericPipeBlock;
        float b = 0.1f;
        double px = target.field_72307_f.field_72450_a + this.rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(b * 2.0f)) + (double)b + block.func_149704_x();
        double py = target.field_72307_f.field_72448_b + this.rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(b * 2.0f)) + (double)b + block.func_149665_z();
        double pz = target.field_72307_f.field_72449_c + this.rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(b * 2.0f)) + (double)b + block.func_149706_B();
        if (sideHit == EnumFacing.DOWN) {
            py = target.field_72307_f.field_72448_b + block.func_149665_z() - (double)b;
        }
        if (sideHit == EnumFacing.UP) {
            py = target.field_72307_f.field_72448_b + block.func_149669_A() + (double)b;
        }
        if (sideHit == EnumFacing.NORTH) {
            pz = target.field_72307_f.field_72449_c + block.func_149706_B() - (double)b;
        }
        if (sideHit == EnumFacing.SOUTH) {
            pz = target.field_72307_f.field_72449_c + block.func_149693_C() + (double)b;
        }
        if (sideHit == EnumFacing.EAST) {
            px = target.field_72307_f.field_72450_a + block.func_149704_x() - (double)b;
        }
        if (sideHit == EnumFacing.WEST) {
            px = target.field_72307_f.field_72450_a + block.func_149753_y() + (double)b;
        }
        EntityFX fx = effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), px, py, pz, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)worldObj.func_180495_p(target.func_178782_a()))});
        fx.func_180435_a(icon);
        effectRenderer.func_78873_a(fx.func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, BlockPos pos, EffectRenderer effectRenderer) {
        Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)worldObj, pos);
        if (pipe == null) {
            return false;
        }
        TextureAtlasSprite icon = pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        int its = 4;
        for (int i = 0; i < its; ++i) {
            for (int j = 0; j < its; ++j) {
                for (int k = 0; k < its; ++k) {
                    double px = (double)pos.func_177958_n() + ((double)i + 0.5) / (double)its;
                    double py = (double)pos.func_177956_o() + ((double)j + 0.5) / (double)its;
                    double pz = (double)pos.func_177952_p() + ((double)k + 0.5) / (double)its;
                    EntityFX fx = effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), px, py, pz, px - (double)pos.func_177958_n() - 0.5, py - (double)pos.func_177956_o() - 0.5, pz - (double)pos.func_177952_p() - 0.5, new int[]{Block.func_176210_f((IBlockState)worldObj.func_180495_p(pos))});
                    fx.func_180435_a(icon);
                }
            }
        }
        return true;
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor colour) {
        TileGenericPipe pipeTile = (TileGenericPipe)world.func_175625_s(pos);
        if (!pipeTile.hasBlockingPluggable(side)) {
            return pipeTile.setPipeColor(colour.func_176765_a());
        }
        return false;
    }

    @Override
    public boolean removeColorFromBlock(World world, BlockPos pos, EnumFacing side) {
        TileGenericPipe pipeTile = (TileGenericPipe)world.func_175625_s(pos);
        if (!pipeTile.hasBlockingPluggable(side)) {
            return pipeTile.setPipeColor(-1);
        }
        return false;
    }

    public TextureAtlasSprite getSprite(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileGenericPipe) {
            Pipe pipe = (Pipe)((TileGenericPipe)tile).getPipe();
            return pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        }
        return PipeIconProvider.TYPE.PipeItemsStone.getIcon();
    }

    public TextureAtlasSprite getIcon(int side, int meta) {
        return PipeIconProvider.TYPE.PipeItemsStone.getIcon();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setCusomStateMappers() {
        final ModelResourceLocation loc = new ModelResourceLocation(Utils.getNameForBlock(this).replace("|", ""));
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return loc;
            }
        });
    }

    @Override
    public float getExtension(World world, BlockPos pos, EnumFacing face, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos.func_177972_a(face.func_176734_d()));
        if (tile == null) {
            return 0.0f;
        }
        if (tile instanceof TileGenericPipe) {
            TileGenericPipe genericPipe = (TileGenericPipe)tile;
            if (genericPipe.pipe instanceof ICustomPipeConnection) {
                return ((ICustomPipeConnection)((Object)genericPipe.pipe)).getExtension(world, pos, face, state);
            }
        }
        return 0.0f;
    }

    private class TraceTester {
        final World world;
        final BlockPos pos;
        final Vec3 origin;
        final Vec3 direction;
        MovingObjectPosition closestHit = null;
        IdentifiableAABB<Part> closestBox = null;
        EnumFacing closestSide = null;
        EnumFacing closestSideHit = null;
        double distance = Double.POSITIVE_INFINITY;

        public TraceTester(World world, BlockPos pos, Vec3 origin, Vec3 direction) {
            this.world = world;
            this.pos = pos;
            this.origin = origin;
            this.direction = direction;
        }

        void test(IdentifiableAABB<Part> bb, EnumFacing side) {
            double lengthSquared;
            BlockGenericPipe.this.setBlockBounds(bb);
            MovingObjectPosition mop = BlockGenericPipe.this.collisionRayTrace_super(this.world, this.pos, this.origin, this.direction);
            if (mop != null && (lengthSquared = mop.field_72307_f.func_72436_e(this.origin)) < this.distance) {
                this.distance = lengthSquared;
                this.closestHit = mop;
                this.closestBox = bb;
                this.closestSide = side == null ? mop.field_178784_b : side;
                this.closestSideHit = mop.field_178784_b;
            }
        }
    }

    public static class RaytraceResult {
        public final Part hitPart;
        public final MovingObjectPosition movingObjectPosition;
        public final IdentifiableAABB<Part> boundingBox;
        public final EnumFacing sideHit;
        public final EnumFacing partSide;

        RaytraceResult(MovingObjectPosition movingObjectPosition, IdentifiableAABB<Part> boundingBox, EnumFacing side, EnumFacing partSide) {
            this.hitPart = (Part)((Object)boundingBox.identifier);
            this.movingObjectPosition = movingObjectPosition;
            this.boundingBox = boundingBox;
            this.sideHit = side;
            this.partSide = partSide;
        }

        public String toString() {
            return "RaytraceResult [hitPart=" + (Object)((Object)this.hitPart) + ", boundingBox=" + this.boundingBox + ", sideHit=" + this.sideHit + ", partSide=" + this.partSide + ",\n movingObjectPosition=" + this.movingObjectPosition + "]";
        }
    }

    public static enum Part {
        Pipe,
        Pluggable,
        Wire;

    }
}

