/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.BCLog;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IFacadePluggable;
import buildcraft.api.transport.pluggable.IPipePluggableStaticRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.render.FacadePluggableRenderer;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;

public class FacadePluggable
extends PipePluggable
implements IFacadePluggable {
    public ItemFacade.FacadeState[] states;
    private ItemFacade.FacadeState activeState;
    private IPipeTile pipe;
    private IBlockState state;
    private boolean transparent;
    private boolean renderAsHollow;

    public FacadePluggable(ItemFacade.FacadeState[] states) {
        this.states = states;
        this.prepareStates();
    }

    public FacadePluggable() {
    }

    @Override
    public void invalidate() {
        this.pipe = null;
    }

    @Override
    public void validate(IPipeTile pipe, EnumFacing direction) {
        this.pipe = pipe;
    }

    @Override
    public boolean requiresRenderUpdate(PipePluggable o) {
        FacadePluggable other = (FacadePluggable)o;
        return other.state != this.state || other.transparent != this.transparent || other.renderAsHollow != this.renderAsHollow;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        if (this.states != null) {
            nbt.func_74782_a("states", (NBTBase)ItemFacade.FacadeState.writeArray(this.states));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("states")) {
            this.states = ItemFacade.FacadeState.readArray(nbt.func_150295_c("states", 10));
        }
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        if (this.states != null) {
            return new ItemStack[]{ItemFacade.getFacade(this.states)};
        }
        return new ItemStack[]{ItemFacade.getFacade(new ItemFacade.FacadeState(this.getCurrentState(), null, this.isHollow()))};
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, EnumFacing direction) {
        return !this.isHollow();
    }

    @Override
    public IBlockState getCurrentState() {
        this.prepareStates();
        return this.activeState == null ? this.state : this.activeState.state;
    }

    @Override
    public boolean isTransparent() {
        this.prepareStates();
        return this.activeState == null ? this.transparent : this.activeState.transparent;
    }

    @Override
    public boolean isHollow() {
        this.prepareStates();
        return this.activeState == null ? this.renderAsHollow : this.activeState.hollow;
    }

    @Override
    public AxisAlignedBB getBoundingBox(EnumFacing side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.0f;
        bounds[0][1] = 1.0f;
        bounds[1][0] = 0.0f;
        bounds[1][1] = 0.125f;
        bounds[2][0] = 0.0f;
        bounds[2][1] = 1.0f;
        MatrixTranformations.transform(bounds, side);
        return new AxisAlignedBB((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    @Override
    public boolean isSolidOnSide(IPipeTile pipe, EnumFacing direction) {
        return !this.isHollow();
    }

    @Override
    public IPipePluggableStaticRenderer getRenderer() {
        return FacadePluggableRenderer.INSTANCE;
    }

    @Override
    public void writeData(ByteBuf data) {
        this.prepareStates();
        if (this.activeState == null || this.activeState.state == null) {
            data.writeShort(0);
        } else {
            data.writeShort(Block.func_149682_b((Block)this.activeState.state.func_177230_c()));
        }
        data.writeByte((this.activeState != null && this.activeState.transparent ? 128 : 0) | (this.activeState != null && this.activeState.hollow ? 64 : 0) | (this.activeState == null ? 0 : this.activeState.state.func_177230_c().func_176201_c(this.activeState.state)));
    }

    @Override
    public void readData(ByteBuf data) {
        int blockId = data.readUnsignedShort();
        Block block = blockId > 0 ? Block.func_149729_e((int)blockId) : null;
        short flags = data.readUnsignedByte();
        int meta = flags & 0xF;
        this.state = block.func_176203_a(meta);
        this.transparent = (flags & 0x80) > 0;
        this.renderAsHollow = (flags & 0x40) > 0;
    }

    private void prepareStates() {
        if (this.states != null && this.states.length > 1) {
            if (this.pipe == null || this.pipe.getPipe() == null) {
                this.activeState = this.states[0];
                return;
            }
            IPipe p = this.pipe.getPipe();
            int defaultStateId = -1;
            int activeStateId = -1;
            for (int i = 0; i < this.states.length; ++i) {
                ItemFacade.FacadeState state = this.states[i];
                if (state.wire == null) {
                    defaultStateId = i;
                    continue;
                }
                if (!p.isWireActive(state.wire)) continue;
                activeStateId = i;
                break;
            }
            this.activeState = activeStateId < 0 ? (defaultStateId < 0 ? this.states[0] : this.states[defaultStateId]) : this.states[activeStateId];
        } else if (this.activeState == null) {
            this.activeState = this.states != null && this.states.length > 0 ? this.states[0] : null;
        }
    }

    public void setActiveState(int activeState2) {
        BCLog.logger.error("TRIED TO SET THE ACTIVE STATE OF A FACEDE PLUGGABLE TO " + activeState2);
    }
}

