/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.GateExpansionController;
import buildcraft.api.gates.IGate;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IActionReceptor;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerExternalOverride;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.statements.containers.IRedstoneStatementContainer;
import buildcraft.api.statements.containers.ISidedStatementContainer;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.PipeWire;
import buildcraft.transport.ActionActiveState;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.gui.ContainerGateInterface;
import buildcraft.transport.statements.ActionValve;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public final class Gate
implements IGate,
ISidedStatementContainer,
IRedstoneStatementContainer {
    public static int MAX_STATEMENTS = 8;
    public static int MAX_PARAMETERS = 3;
    public final Pipe<?> pipe;
    public final GateDefinition.GateMaterial material;
    public final GateDefinition.GateLogic logic;
    public final BiMap<IGateExpansion, GateExpansionController> expansions = HashBiMap.create();
    public IStatement[] triggers = new IStatement[MAX_STATEMENTS];
    public IStatementParameter[][] triggerParameters = new IStatementParameter[MAX_STATEMENTS][MAX_PARAMETERS];
    public IStatement[] actions = new IStatement[MAX_STATEMENTS];
    public IStatementParameter[][] actionParameters = new IStatementParameter[MAX_STATEMENTS][MAX_PARAMETERS];
    public ActionActiveState[] actionsState = new ActionActiveState[MAX_STATEMENTS];
    public ArrayList<StatementSlot> activeActions = new ArrayList();
    public byte broadcastSignal;
    public byte prevBroadcastSignal;
    public int redstoneOutput = 0;
    public int redstoneOutputSide = 0;
    public boolean isPulsing = false;
    private EnumFacing direction;
    private HashMultiset<IStatement> statementCounts = HashMultiset.create();
    private int[] actionGroups = new int[]{0, 1, 2, 3, 4, 5, 6, 7};

    public Gate(Pipe<?> pipe, GateDefinition.GateMaterial material, GateDefinition.GateLogic logic, EnumFacing direction) {
        this.pipe = pipe;
        this.material = material;
        this.logic = logic;
        this.direction = direction;
        for (int i = 0; i < this.actionsState.length; ++i) {
            this.actionsState[i] = ActionActiveState.Deactivated;
        }
    }

    public void setTrigger(int position, IStatement trigger) {
        if (trigger != this.triggers[position]) {
            for (int i = 0; i < this.triggerParameters[position].length; ++i) {
                this.triggerParameters[position][i] = null;
            }
        }
        this.triggers[position] = trigger;
    }

    public IStatement getTrigger(int position) {
        return this.triggers[position];
    }

    public void setAction(int position, IStatement action) {
        if (this.actions[position] instanceof ActionValve && this.pipe != null && this.pipe.transport != null) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                ((PipeTransport)this.pipe.transport).allowInput(side, true);
                ((PipeTransport)this.pipe.transport).allowOutput(side, true);
            }
        }
        if (action != this.actions[position]) {
            for (int i = 0; i < this.actionParameters[position].length; ++i) {
                this.actionParameters[position][i] = null;
            }
        }
        this.actions[position] = action;
        this.recalculateActionGroups();
    }

    public IStatement getAction(int position) {
        return this.actions[position];
    }

    public void setTriggerParameter(int trigger, int param, IStatementParameter p) {
        this.triggerParameters[trigger][param] = p;
    }

    public void setActionParameter(int action, int param, IStatementParameter p) {
        this.actionParameters[action][param] = p;
        this.recalculateActionGroups();
    }

    public IStatementParameter getTriggerParameter(int trigger, int param) {
        return this.triggerParameters[trigger][param];
    }

    public IStatementParameter getActionParameter(int action, int param) {
        return this.actionParameters[action][param];
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
    }

    public void addGateExpansion(IGateExpansion expansion) {
        if (!this.expansions.containsKey((Object)expansion)) {
            this.expansions.put((Object)expansion, (Object)expansion.makeController(this.pipe != null ? this.pipe.container : null));
        }
    }

    public void writeStatementsToNBT(NBTTagCompound data) {
        for (int i = 0; i < this.material.numSlots; ++i) {
            NBTTagCompound cpt;
            int j;
            if (this.triggers[i] != null) {
                data.func_74778_a("trigger[" + i + "]", this.triggers[i].getUniqueTag());
            }
            if (this.actions[i] != null) {
                data.func_74778_a("action[" + i + "]", this.actions[i].getUniqueTag());
            }
            for (j = 0; j < this.material.numTriggerParameters; ++j) {
                if (this.triggerParameters[i][j] == null) continue;
                cpt = new NBTTagCompound();
                cpt.func_74778_a("kind", this.triggerParameters[i][j].getUniqueTag());
                this.triggerParameters[i][j].writeToNBT(cpt);
                data.func_74782_a("triggerParameters[" + i + "][" + j + "]", (NBTBase)cpt);
            }
            for (j = 0; j < this.material.numActionParameters; ++j) {
                if (this.actionParameters[i][j] == null) continue;
                cpt = new NBTTagCompound();
                cpt.func_74778_a("kind", this.actionParameters[i][j].getUniqueTag());
                this.actionParameters[i][j].writeToNBT(cpt);
                data.func_74782_a("actionParameters[" + i + "][" + j + "]", (NBTBase)cpt);
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74778_a("material", this.material.name());
        data.func_74778_a("logic", this.logic.name());
        data.func_74768_a("direction", this.direction.ordinal());
        NBTTagList exList = new NBTTagList();
        for (GateExpansionController con : this.expansions.values()) {
            NBTTagCompound conNBT = new NBTTagCompound();
            conNBT.func_74778_a("type", con.getType().getUniqueIdentifier());
            NBTTagCompound conData = new NBTTagCompound();
            con.writeToNBT(conData);
            conNBT.func_74782_a("data", (NBTBase)conData);
            exList.func_74742_a((NBTBase)conNBT);
        }
        data.func_74782_a("expansions", (NBTBase)exList);
        this.writeStatementsToNBT(data);
        data.func_74774_a("wireState", this.broadcastSignal);
        data.func_74774_a("redstoneOutput", (byte)this.redstoneOutput);
    }

    public void readStatementsFromNBT(NBTTagCompound data) {
        int j;
        int i;
        for (i = 0; i < this.material.numSlots; ++i) {
            this.triggers[i] = null;
            this.actions[i] = null;
            for (j = 0; j < this.material.numTriggerParameters; ++j) {
                this.triggerParameters[i][j] = null;
            }
            for (j = 0; j < this.material.numActionParameters; ++j) {
                this.actionParameters[i][j] = null;
            }
        }
        for (i = 0; i < this.material.numSlots; ++i) {
            NBTTagCompound cpt;
            if (data.func_74764_b("trigger[" + i + "]")) {
                this.triggers[i] = StatementManager.statements.get(data.func_74779_i("trigger[" + i + "]"));
            }
            if (data.func_74764_b("action[" + i + "]")) {
                this.actions[i] = StatementManager.statements.get(data.func_74779_i("action[" + i + "]"));
            }
            if (data.func_74764_b("triggerParameters[" + i + "]")) {
                this.triggerParameters[i][0] = new StatementParameterItemStack();
                this.triggerParameters[i][0].readFromNBT(data.func_74775_l("triggerParameters[" + i + "]"));
            }
            for (j = 0; j < this.material.numTriggerParameters; ++j) {
                if (!data.func_74764_b("triggerParameters[" + i + "][" + j + "]")) continue;
                cpt = data.func_74775_l("triggerParameters[" + i + "][" + j + "]");
                this.triggerParameters[i][j] = StatementManager.createParameter(cpt.func_74779_i("kind"));
                this.triggerParameters[i][j].readFromNBT(cpt);
            }
            for (j = 0; j < this.material.numActionParameters; ++j) {
                if (!data.func_74764_b("actionParameters[" + i + "][" + j + "]")) continue;
                cpt = data.func_74775_l("actionParameters[" + i + "][" + j + "]");
                this.actionParameters[i][j] = StatementManager.createParameter(cpt.func_74779_i("kind"));
                this.actionParameters[i][j].readFromNBT(cpt);
            }
        }
        this.recalculateActionGroups();
    }

    public boolean verifyGateStatements() {
        List<IStatement> triggerList = this.getAllValidTriggers();
        List<IStatement> actionList = this.getAllValidActions();
        boolean warning = false;
        for (int i = 0; i < MAX_STATEMENTS; ++i) {
            if ((this.triggers[i] != null || this.actions[i] != null) && i >= this.material.numSlots) {
                this.triggers[i] = null;
                this.actions[i] = null;
                warning = true;
                continue;
            }
            if (!(this.triggers[i] == null || triggerList.contains(this.triggers[i]) && this.triggers[i].minParameters() <= this.material.numTriggerParameters)) {
                this.triggers[i] = null;
                warning = true;
            }
            if (this.actions[i] == null || actionList.contains(this.actions[i]) && this.actions[i].minParameters() <= this.material.numActionParameters) continue;
            this.actions[i] = null;
            warning = true;
        }
        if (warning) {
            this.recalculateActionGroups();
        }
        return !warning;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.readStatementsFromNBT(data);
        if (data.func_74764_b("wireState[0]")) {
            for (PipeWire wire : PipeWire.VALUES) {
                if (!data.func_74767_n("wireState[" + wire.ordinal() + "]")) continue;
                this.broadcastSignal = (byte)(this.broadcastSignal | 1 << wire.ordinal());
            }
        } else {
            this.broadcastSignal = data.func_74771_c("wireState");
        }
        this.redstoneOutput = data.func_74771_c("redstoneOutput");
    }

    public void openGui(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.openGui((Object)BuildCraftTransport.instance, 51, this.pipe.container.func_145831_w(), this.pipe.container.func_174877_v().func_177958_n(), this.pipe.container.func_174877_v().func_177956_o(), this.pipe.container.func_174877_v().func_177952_p());
            ((ContainerGateInterface)player.field_71070_bA).setGate(this.direction.ordinal());
        }
    }

    public void tick() {
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.tick(this);
        }
    }

    public ItemStack getGateItem() {
        return ItemGate.makeGateItem(this);
    }

    public void dropGate() {
        this.pipe.dropItem(this.getGateItem());
    }

    public void resetGate() {
        if (this.redstoneOutput != 0) {
            this.redstoneOutput = 0;
            this.pipe.updateNeighbors(true);
        }
    }

    public boolean isGateActive() {
        for (ActionActiveState state : this.actionsState) {
            if (state != ActionActiveState.Activated) continue;
            return true;
        }
        return false;
    }

    public boolean isGatePulsing() {
        return this.isPulsing;
    }

    public int getRedstoneOutput() {
        return this.redstoneOutput;
    }

    public int getSidedRedstoneOutput() {
        return this.redstoneOutputSide;
    }

    public void setRedstoneOutput(boolean sideOnly, int value) {
        this.redstoneOutputSide = value;
        if (!sideOnly) {
            this.redstoneOutput = value;
        }
    }

    public void startResolution() {
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.startResolution();
        }
    }

    public void resolveActions() {
        boolean isActive;
        int it;
        int oldRedstoneOutput = this.redstoneOutput;
        this.redstoneOutput = 0;
        int oldRedstoneOutputSide = this.redstoneOutputSide;
        this.redstoneOutputSide = 0;
        boolean wasActive = this.activeActions.size() > 0;
        this.prevBroadcastSignal = this.broadcastSignal;
        this.broadcastSignal = 0;
        this.startResolution();
        for (it = 0; it < MAX_STATEMENTS; ++it) {
            this.actionsState[it] = ActionActiveState.Deactivated;
            IStatement trigger = this.triggers[it];
            IStatementParameter[] parameter = this.triggerParameters[it];
            if (trigger == null || !this.isTriggerActive(trigger, parameter)) continue;
            this.actionsState[it] = ActionActiveState.Partial;
        }
        this.activeActions.clear();
        for (it = 0; it < MAX_STATEMENTS; ++it) {
            int j;
            boolean allActive = true;
            boolean oneActive = false;
            if (this.actions[it] == null) continue;
            for (j = 0; j < MAX_STATEMENTS; ++j) {
                if (this.actionGroups[j] != it) continue;
                if (this.actionsState[j] != ActionActiveState.Partial) {
                    allActive = false;
                    continue;
                }
                oneActive = true;
            }
            if (this.logic == GateDefinition.GateLogic.AND && allActive && oneActive || this.logic == GateDefinition.GateLogic.OR && oneActive) {
                if (this.logic == GateDefinition.GateLogic.AND) {
                    for (j = 0; j < MAX_STATEMENTS; ++j) {
                        if (this.actionGroups[j] != it) continue;
                        this.actionsState[j] = ActionActiveState.Activated;
                    }
                }
                StatementSlot slot = new StatementSlot();
                slot.statement = this.actions[it];
                slot.parameters = this.actionParameters[it];
                this.activeActions.add(slot);
            }
            if (this.logic != GateDefinition.GateLogic.OR || this.actionsState[it] != ActionActiveState.Partial) continue;
            this.actionsState[it] = ActionActiveState.Activated;
        }
        this.statementCounts.clear();
        for (it = 0; it < MAX_STATEMENTS; ++it) {
            if (this.actionsState[it] != ActionActiveState.Activated) continue;
            this.statementCounts.add((Object)this.actions[it], 1);
        }
        for (StatementSlot slot : this.activeActions) {
            TileEntity tile;
            IStatement action = slot.statement;
            if (action instanceof IActionInternal) {
                ((IActionInternal)action).actionActivate(this, slot.parameters);
            } else {
                if (!(action instanceof IActionExternal)) continue;
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    tile = this.getPipe().getTile().getNeighborTile(side);
                    if (tile == null) continue;
                    ((IActionExternal)action).actionActivate(tile, side, this, slot.parameters);
                }
            }
            if (this.resolveAction(action)) continue;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                tile = this.pipe.container.getTile(side);
                if (!(tile instanceof IActionReceptor)) continue;
                IActionReceptor recept = (IActionReceptor)tile;
                recept.actionActivated(action, slot.parameters);
            }
        }
        this.pipe.actionsActivated(this.activeActions);
        if (oldRedstoneOutput != this.redstoneOutput || oldRedstoneOutputSide != this.redstoneOutputSide) {
            this.pipe.updateNeighbors(true);
        }
        if (this.prevBroadcastSignal != this.broadcastSignal) {
            this.pipe.scheduleWireUpdate();
        }
        boolean bl = isActive = this.activeActions.size() > 0;
        if (wasActive != isActive) {
            this.pipe.container.scheduleRenderUpdate();
        }
    }

    public boolean resolveAction(IStatement action) {
        for (GateExpansionController expansion : this.expansions.values()) {
            if (!expansion.resolveAction(action, this.statementCounts.count((Object)action))) continue;
            return true;
        }
        return false;
    }

    public boolean isTriggerActive(IStatement trigger, IStatementParameter[] parameters) {
        if (trigger == null) {
            return false;
        }
        if (trigger instanceof ITriggerInternal) {
            if (((ITriggerInternal)trigger).isTriggerActive(this, parameters)) {
                return true;
            }
        } else if (trigger instanceof ITriggerExternal) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                TileEntity tile = this.getPipe().getTile().getNeighborTile(side);
                if (tile == null) continue;
                if (tile instanceof ITriggerExternalOverride) {
                    ITriggerExternalOverride.Result result = ((ITriggerExternalOverride)tile).override(side, this, parameters);
                    if (result == ITriggerExternalOverride.Result.TRUE) {
                        return true;
                    }
                    if (result == ITriggerExternalOverride.Result.FALSE) continue;
                }
                if (!((ITriggerExternal)trigger).isTriggerActive(tile, side, this, parameters)) continue;
                return true;
            }
        }
        for (GateExpansionController expansion : this.expansions.values()) {
            if (!expansion.isTriggerActive(trigger, parameters)) continue;
            return true;
        }
        return false;
    }

    public void addTriggers(List<ITriggerInternal> list) {
        for (PipeWire wire : PipeWire.VALUES) {
            if (!this.pipe.wireSet[wire.ordinal()] || wire.ordinal() >= this.material.maxWireColor) continue;
            list.add(BuildCraftTransport.triggerPipeWireActive[wire.ordinal()]);
            list.add(BuildCraftTransport.triggerPipeWireInactive[wire.ordinal()]);
        }
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.addTriggers(list);
        }
    }

    public List<IStatement> getAllValidTriggers() {
        ArrayList<IStatement> allTriggers = new ArrayList<IStatement>(64);
        allTriggers.addAll(StatementManager.getInternalTriggers(this));
        for (EnumFacing o : EnumFacing.field_82609_l) {
            TileEntity tile = this.pipe.container.getTile(o);
            allTriggers.addAll(StatementManager.getExternalTriggers(o, tile));
        }
        return allTriggers;
    }

    public void addActions(List<IActionInternal> list) {
        for (PipeWire wire : PipeWire.VALUES) {
            if (!this.pipe.wireSet[wire.ordinal()] || wire.ordinal() >= this.material.maxWireColor) continue;
            list.add(BuildCraftTransport.actionPipeWire[wire.ordinal()]);
        }
        for (GateExpansionController expansion : this.expansions.values()) {
            expansion.addActions(list);
        }
    }

    public List<IStatement> getAllValidActions() {
        ArrayList<IStatement> allActions = new ArrayList<IStatement>(64);
        allActions.addAll(StatementManager.getInternalActions(this));
        for (EnumFacing o : EnumFacing.field_82609_l) {
            TileEntity tile = this.pipe.container.getTile(o);
            allActions.addAll(StatementManager.getExternalActions(o, tile));
        }
        return allActions;
    }

    @Override
    public void setPulsing(boolean pulsing) {
        if (pulsing != this.isPulsing) {
            this.isPulsing = pulsing;
            this.pipe.container.scheduleRenderUpdate();
        }
    }

    private void recalculateActionGroups() {
        for (int i = 0; i < MAX_STATEMENTS; ++i) {
            this.actionGroups[i] = i;
            for (int j = i - 1; j >= 0; --j) {
                if (this.actions[i] == null || this.actions[j] == null || !this.actions[i].getUniqueTag().equals(this.actions[j].getUniqueTag())) continue;
                boolean sameParams = true;
                for (int p = 0; p < MAX_PARAMETERS; ++p) {
                    if (!(this.actionParameters[i][p] != null && this.actionParameters[j][p] == null || this.actionParameters[i][p] == null && this.actionParameters[j][p] != null) && (this.actionParameters[i][p] == null || this.actionParameters[j][p] == null || this.actionParameters[i][p].equals(this.actionParameters[j][p]))) continue;
                    sameParams = false;
                    break;
                }
                if (!sameParams) continue;
                this.actionGroups[i] = j;
            }
        }
    }

    public void broadcastSignal(PipeWire color) {
        this.broadcastSignal = (byte)(this.broadcastSignal | 1 << color.ordinal());
    }

    @Override
    public IPipe getPipe() {
        return this.pipe;
    }

    @Override
    public EnumFacing getSide() {
        return this.direction;
    }

    @Override
    public TileEntity getTile() {
        return this.pipe.container;
    }

    @Override
    public List<IStatement> getTriggers() {
        return Arrays.asList(this.triggers).subList(0, this.material.numSlots);
    }

    @Override
    public List<IStatement> getActions() {
        return Arrays.asList(this.actions).subList(0, this.material.numSlots);
    }

    @Override
    public List<StatementSlot> getActiveActions() {
        return this.activeActions;
    }

    @Override
    public List<IStatementParameter> getTriggerParameters(int index) {
        if (index < 0 || index >= this.material.numSlots) {
            return null;
        }
        return Arrays.asList(this.triggerParameters[index]).subList(0, this.material.numTriggerParameters);
    }

    @Override
    public List<IStatementParameter> getActionParameters(int index) {
        if (index < 0 || index >= this.material.numSlots) {
            return null;
        }
        return Arrays.asList(this.actionParameters[index]).subList(0, this.material.numActionParameters);
    }

    @Override
    public int getRedstoneInput(EnumFacing side) {
        return side == null ? this.pipe.container.redstoneInput : this.pipe.container.redstoneInputSide[side.ordinal()];
    }

    @Override
    public boolean setRedstoneOutput(EnumFacing side, int value) {
        if (side != this.getSide() && side != null) {
            return false;
        }
        this.setRedstoneOutput(side != null, value);
        return true;
    }
}

